<?php $__env->startSection('title', __('mosque::mosque.settings_title')); ?>

<?php $__env->startSection('content'); ?>
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black"><?php echo app('translator')->get('mosque::mosque.settings_title'); ?></h1>
</section>

<section class="content">
    <?php echo $__env->make('layouts.partials.error', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
        <div class="row">
            <div class="col-sm-6">
                <p><strong><?php echo app('translator')->get('mosque::mosque.license_masked'); ?>:</strong> <?php echo e($license_masked ?? '—', false); ?></p>
                <p><strong><?php echo app('translator')->get('mosque::mosque.activated_at'); ?>:</strong> <?php echo e(!empty($license) && !empty($license->activated_at) ? $license->activated_at->format('Y-m-d H:i') : '—', false); ?></p>
            </div>
            <div class="col-sm-6 text-right">
                <form method="post" action="<?php echo e(route('mosque.settings.deactivate'), false); ?>" onsubmit="return confirm('Are you sure?');">
                    <?php echo e(csrf_field(), false); ?>

                    <button type="submit" class="tw-dw-btn tw-dw-btn-error tw-text-white"><?php echo app('translator')->get('mosque::mosque.deactivate'); ?></button>
                </form>
            </div>
        </div>
    <?php echo $__env->renderComponent(); ?>

    <?php
        $logoVersion = !empty($profile) && !empty($profile->updated_at)
            ? (string) $profile->updated_at->timestamp
            : (string) time();
        $profileLogoUrl = !empty($profile) && !empty($profile->logo)
            ? route('mosque.logo', ['filename' => (string) $profile->logo]).'?v='.$logoVersion
            : null;
    ?>

    <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
        <h4>Mosque Profile</h4>
        <form method="post" action="<?php echo e(route('mosque.settings.profile.update'), false); ?>" enctype="multipart/form-data">
            <?php echo e(csrf_field(), false); ?>

            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Name</label>
                        <input type="text" name="name" class="form-control" value="<?php echo e($profile->name ?? '', false); ?>">
                    </div>
                    <div class="form-group">
                        <label>Address</label>
                        <textarea name="address" class="form-control" rows="3"><?php echo e($profile->address ?? '', false); ?></textarea>
                    </div>
                    <div class="form-group">
                        <label>Registration No</label>
                        <input type="text" name="reg_no" class="form-control" value="<?php echo e($profile->reg_no ?? '', false); ?>">
                    </div>
                    <div class="form-group">
                        <label>Contact number</label>
                        <input type="text" name="phone" class="form-control" value="<?php echo e($profile->phone ?? '', false); ?>" placeholder="+8801XXXXXXXXX">
                    </div>
                    <div class="form-group">
                        <label>Email</label>
                        <input type="email" name="email" class="form-control" value="<?php echo e($profile->email ?? '', false); ?>" placeholder="mosque@example.com">
                    </div>
                </div>

                <div class="col-sm-6">
                     <div class="form-group">
                         <label>Country</label>
                         <select name="country" id="mosque_country" class="form-control select2" style="width: 100%;">
                             <option value=""><?php echo app('translator')->get('lang_v1.none'); ?></option>
                             <?php ($profileCountry = (string) ($profile->country ?? '')); ?>
                             <?php $__currentLoopData = ($countries ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                 <?php ($cc = strtoupper((string) ($row['cc'] ?? ''))); ?>
                                 <?php ($name = (string) ($row['name'] ?? '')); ?>
                                 <?php ($selected = (!empty($name) && strcasecmp($profileCountry, $name) === 0) || (!empty($cc) && strtoupper($profileCountry) === $cc)); ?>
                                 <?php if($cc !== '' && $name !== ''): ?>
                                     <option value="<?php echo e($name, false); ?>" data-cc="<?php echo e($cc, false); ?>" <?php echo e($selected ? 'selected' : '', false); ?>><?php echo e($name, false); ?> (<?php echo e($cc, false); ?>)</option>
                                 <?php endif; ?>
                             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                         </select>
                     </div>
                    <div class="form-group">
                        <label>Timezone</label>
                        <?php ($profileTz = (string) ($profile->timezone ?? '')); ?>
                        <?php ($defaultTz = !empty($profileTz) ? $profileTz : (string) ($business_timezone ?? '')); ?>
                        <select name="timezone" id="mosque_timezone" class="form-control select2" style="width: 100%;">
                            <option value=""><?php echo app('translator')->get('lang_v1.none'); ?></option>
                            <?php $__currentLoopData = ($timezones ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tz): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($tz, false); ?>" <?php echo e($defaultTz === $tz ? 'selected' : '', false); ?>><?php echo e($tz, false); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <p class="help-block">Defaults to Ultimate POS business timezone; used on module documents.</p>
                    </div>
                    <div class="form-group">
                        <label>Logo (optional)</label>
                        <input type="file" name="logo" class="form-control">
                        <?php if(!empty($profileLogoUrl)): ?>
                            <div style="margin-top:8px;">
                                <img src="<?php echo e($profileLogoUrl, false); ?>" alt="Logo" style="max-height:70px;">
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="col-sm-12">
                    <div class="form-group">
                        <label>Header Text (optional)</label>
                        <textarea name="header_text" class="form-control" rows="3" placeholder="Shown on receipts/certificates"><?php echo e($profile->header_text ?? '', false); ?></textarea>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-12 text-right">
                    <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('messages.save'); ?></button>
                </div>
            </div>
        </form>
    <?php echo $__env->renderComponent(); ?>

    <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
        <div class="row">
            <div class="col-sm-12 text-right">
                <a href="<?php echo e(route('mosque.automation.reminders'), false); ?>" class="btn btn-default">
                    <i class="fa fa-bell"></i> Reminders
                </a>
            </div>
        </div>
    <?php echo $__env->renderComponent(); ?>

    <?php ($settings = !empty($settings_row) ? ($settings_row->settings ?: []) : []); ?>
    <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
        <form method="post" action="<?php echo e(route('mosque.settings.update'), false); ?>">
            <?php echo e(csrf_field(), false); ?>

            <div class="row">
                <div class="col-sm-6">
                    <h4>Feature Toggles</h4>

                    <div class="form-group">
                        <label>Currency (module documents)</label>
                        <select name="currency_id" id="mosque_currency_id" class="form-control select2" style="width: 100%;">
                            <option value=""><?php echo app('translator')->get('lang_v1.none'); ?></option>
                            <?php $__currentLoopData = ($currencies ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php ($curText = trim(($cur->country ?? '').' - '.($cur->currency ?? '').' ('.($cur->code ?? '').') '.($cur->symbol ?? ''))); ?>
                                <option value="<?php echo e($cur->id, false); ?>" <?php echo e((int) ($settings['currency_id'] ?? 0) === (int) $cur->id ? 'selected' : '', false); ?>><?php echo e($curText, false); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <p class="help-block">If empty, uses Ultimate POS business currency.</p>
                    </div>

                    <div class="checkbox">
                        <label>
                            <input type="checkbox" name="qr_attendance_enabled" value="1" <?php echo e(!empty($settings['qr_attendance_enabled']) ? 'checked' : '', false); ?>>
                            QR Attendance (optional)
                        </label>
                    </div>
                    <div class="checkbox">
                        <label>
                            <input type="checkbox" name="hijri_display_enabled" value="1" <?php echo e(!empty($settings['hijri_display_enabled']) ? 'checked' : '', false); ?>>
                            Hijri Calendar display
                        </label>
                    </div>
                    <div class="checkbox">
                        <label>
                            <input type="checkbox" name="reminders_donations_enabled" value="1" <?php echo e(!empty($settings['reminders_donations_enabled']) ? 'checked' : '', false); ?>>
                            Donation reminders
                        </label>
                    </div>
                    <div class="checkbox">
                        <label>
                            <input type="checkbox" name="reminders_membership_enabled" value="1" <?php echo e(!empty($settings['reminders_membership_enabled']) ? 'checked' : '', false); ?>>
                            Membership due reminders
                        </label>
                    </div>
                    <div class="checkbox">
                        <label>
                            <input type="checkbox" name="pledges_enabled" value="1" <?php echo e(array_key_exists('pledges_enabled', $settings) ? (!empty($settings['pledges_enabled']) ? 'checked' : '') : 'checked', false); ?>>
                            Enable Pledges/Commitments
                        </label>
                    </div>
                    <div class="form-group">
                        <label>Pledge reminder windows (days)</label>
                        <input type="text" name="pledges_reminder_windows" class="form-control" value="<?php echo e($settings['pledges_reminder_windows'] ?? '7,30', false); ?>" placeholder="7,30">
                        <p class="help-block">Comma-separated days; used for Due Soon chips and reminders.</p>
                    </div>

                    <h4 style="margin-top:18px;">Prayer</h4>
                    <div class="form-group">
                        <label>Prayer calculation preference</label>
                        <select name="prayer_calc_preference" class="form-control">
                            <?php ($pref = (string) ($settings['prayer_calc_preference'] ?? '')); ?>
                            <option value=""><?php echo app('translator')->get('lang_v1.none'); ?></option>
                            <option value="manual" <?php echo e($pref === 'manual' ? 'selected' : '', false); ?>>Manual</option>
                            <option value="umm_al_qura" <?php echo e($pref === 'umm_al_qura' ? 'selected' : '', false); ?>>Umm Al-Qura</option>
                            <option value="karachi" <?php echo e($pref === 'karachi' ? 'selected' : '', false); ?>>Karachi</option>
                            <option value="isna" <?php echo e($pref === 'isna' ? 'selected' : '', false); ?>>ISNA</option>
                            <option value="egypt" <?php echo e($pref === 'egypt' ? 'selected' : '', false); ?>>Egypt</option>
                        </select>
                        <p class="help-block">Store preference only; timetable calculation can be manual (Phase 2).</p>
                    </div>
                    <div class="form-group">
                        <label>Manual prayer note (optional)</label>
                        <textarea name="prayer_calc_manual_note" class="form-control" rows="2" placeholder="Example: Use local timetable from authority..."><?php echo e($settings['prayer_calc_manual_note'] ?? '', false); ?></textarea>
                    </div>

                    <div class="form-group">
                        <label>EU/Middle-East receipt wording (optional)</label>
                        <textarea name="eu_receipt_wording" class="form-control" rows="4" placeholder="Country-specific wording shown on donation/membership receipts"><?php echo e($settings['eu_receipt_wording'] ?? '', false); ?></textarea>
                    </div>

                    <?php ($dpi = (array) ($settings['donation_payment_info'] ?? [])); ?>
                    <?php ($dpiMobile = (array) ($dpi['mobile'] ?? [])); ?>
                    <?php ($dpiBank = (array) ($dpi['bank'] ?? [])); ?>
                    <?php ($dpiCash = (array) ($dpi['cash'] ?? [])); ?>

                    <h4 style="margin-top:18px;">Donation Payment Info</h4>
                    <p class="help-block">Save payment gateway details (Mobile, Bank, Cash on hand) to reuse on donation pages/receipts.</p>

                    <h4 style="margin-top:12px;">Mobile Payment Gateway</h4>
                    <?php for($i = 1; $i <= 3; $i++): ?>
                        <?php ($row = (array) ($dpiMobile[$i-1] ?? [])); ?>
                        <div class="row" style="margin-bottom:8px;">
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label>Mobile <?php echo e($i, false); ?> Name</label>
                                    <div class="input-group">
                                        <span class="input-group-addon"><i class="fa fa-mobile"></i></span>
                                        <input type="text" name="donation_pay_mobile_<?php echo e($i, false); ?>_name" class="form-control" value="<?php echo e($row['name'] ?? '', false); ?>" placeholder="bKash / Nagad / Rocket">
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label>Mobile <?php echo e($i, false); ?> Number</label>
                                    <div class="input-group">
                                        <span class="input-group-addon"><i class="fa fa-whatsapp"></i></span>
                                        <input type="text" name="donation_pay_mobile_<?php echo e($i, false); ?>_number" class="form-control" value="<?php echo e($row['number'] ?? '', false); ?>" placeholder="+8801XXXXXXXXX">
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label>Note (optional)</label>
                                    <input type="text" name="donation_pay_mobile_<?php echo e($i, false); ?>_note" class="form-control" value="<?php echo e($row['note'] ?? '', false); ?>" placeholder="Personal / Merchant / Ref">
                                </div>
                            </div>
                        </div>
                    <?php endfor; ?>

                    <h4 style="margin-top:14px;">Bank</h4>
                    <?php for($i = 1; $i <= 3; $i++): ?>
                        <?php ($row = (array) ($dpiBank[$i-1] ?? [])); ?>
                        <div class="row" style="margin-bottom:8px;">
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label>Bank <?php echo e($i, false); ?> Name</label>
                                    <div class="input-group">
                                        <span class="input-group-addon"><i class="fa fa-university"></i></span>
                                        <input type="text" name="donation_pay_bank_<?php echo e($i, false); ?>_bank_name" class="form-control" value="<?php echo e($row['bank_name'] ?? '', false); ?>" placeholder="Bank name">
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label>Account Name</label>
                                    <input type="text" name="donation_pay_bank_<?php echo e($i, false); ?>_account_name" class="form-control" value="<?php echo e($row['account_name'] ?? '', false); ?>" placeholder="Account name">
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label>Account No</label>
                                    <input type="text" name="donation_pay_bank_<?php echo e($i, false); ?>_account_no" class="form-control" value="<?php echo e($row['account_no'] ?? '', false); ?>" placeholder="Account number">
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label>Branch</label>
                                    <input type="text" name="donation_pay_bank_<?php echo e($i, false); ?>_branch" class="form-control" value="<?php echo e($row['branch'] ?? '', false); ?>" placeholder="Branch">
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label>Routing (optional)</label>
                                    <input type="text" name="donation_pay_bank_<?php echo e($i, false); ?>_routing" class="form-control" value="<?php echo e($row['routing'] ?? '', false); ?>" placeholder="Routing/SWIFT">
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label>Note (optional)</label>
                                    <input type="text" name="donation_pay_bank_<?php echo e($i, false); ?>_note" class="form-control" value="<?php echo e($row['note'] ?? '', false); ?>" placeholder="Ref / instructions">
                                </div>
                            </div>
                        </div>
                    <?php endfor; ?>

                    <h4 style="margin-top:14px;">Cash on Hand</h4>
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label>Label</label>
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="fa fa-money"></i></span>
                                    <input type="text" name="donation_pay_cash_label" class="form-control" value="<?php echo e($dpiCash['label'] ?? '', false); ?>" placeholder="Cash Counter / Office">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label>Note (optional)</label>
                                <input type="text" name="donation_pay_cash_note" class="form-control" value="<?php echo e($dpiCash['note'] ?? '', false); ?>" placeholder="When/where to pay cash">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-sm-6">
                    <h4>Templates</h4>
                    <div class="form-group">
                        <label>Donation receipt template</label>
                        <textarea name="template_donation_receipt" class="form-control" rows="5" placeholder="Template text..."><?php echo e($settings['template_donation_receipt'] ?? '', false); ?></textarea>
                    </div>
                    <div class="form-group">
                        <label>Membership receipt template</label>
                        <textarea name="template_membership_receipt" class="form-control" rows="5" placeholder="Template text..."><?php echo e($settings['template_membership_receipt'] ?? '', false); ?></textarea>
                    </div>
                    <div class="form-group">
                        <label>Donation reminder email subject</label>
                        <input type="text" name="template_donation_reminder_subject" class="form-control" value="<?php echo e($settings['template_donation_reminder_subject'] ?? '', false); ?>" placeholder="Donation Reminder">
                    </div>
                    <div class="form-group">
                        <label>Donation reminder email template</label>
                        <textarea name="template_donation_reminder_email" class="form-control" rows="4" placeholder="Use tokens: {donor}, {mosque}, {business}, {date}"><?php echo e($settings['template_donation_reminder_email'] ?? '', false); ?></textarea>
                    </div>
                    <div class="form-group">
                        <label>Membership reminder email subject</label>
                        <input type="text" name="template_membership_reminder_subject" class="form-control" value="<?php echo e($settings['template_membership_reminder_subject'] ?? '', false); ?>" placeholder="Membership Due Reminder">
                    </div>
                    <div class="form-group">
                        <label>Membership reminder email template</label>
                        <textarea name="template_membership_reminder_email" class="form-control" rows="4" placeholder="Use tokens: {member}, {period_ym}, {amount_due}, {mosque}, {business}, {date}"><?php echo e($settings['template_membership_reminder_email'] ?? '', false); ?></textarea>
                    </div>

                    <h4 style="margin-top:18px;">Pledge Reminders</h4>
                    <div class="form-group">
                        <label>Pledge reminder WhatsApp template</label>
                        <textarea name="template_pledge_reminder_whatsapp" class="form-control" rows="3" placeholder="Use tokens: {business_name} {donor_name} {pledge_code} {type} {due_date} {balance} {pay_link}"><?php echo e($settings['template_pledge_reminder_whatsapp'] ?? '', false); ?></textarea>
                    </div>
                    <div class="form-group">
                        <label>Pledge reminder SMS template</label>
                        <textarea name="template_pledge_reminder_sms" class="form-control" rows="3" placeholder="Use tokens: {business_name} {donor_name} {pledge_code} {type} {due_date} {balance} {pay_link}"><?php echo e($settings['template_pledge_reminder_sms'] ?? '', false); ?></textarea>
                    </div>
                    <div class="form-group">
                        <label>Pledge reminder email subject</label>
                        <input type="text" name="template_pledge_reminder_email_subject" class="form-control" value="<?php echo e($settings['template_pledge_reminder_email_subject'] ?? '', false); ?>" placeholder="Pledge Reminder: {pledge_code}">
                    </div>
                    <div class="form-group">
                        <label>Pledge reminder email template</label>
                        <textarea name="template_pledge_reminder_email" class="form-control" rows="4" placeholder="Use tokens: {business_name} {donor_name} {pledge_code} {type} {due_date} {balance} {pay_link}"><?php echo e($settings['template_pledge_reminder_email'] ?? '', false); ?></textarea>
                    </div>
                    <div class="form-group">
                        <label>Default WhatsApp country code</label>
                        <input type="text" name="whatsapp_default_country_code" class="form-control" value="<?php echo e($settings['whatsapp_default_country_code'] ?? '', false); ?>" placeholder="880">
                        <small class="text-muted">Example: Bangladesh = 880. If members save mobile like 019xxxxxxxx, system will auto prefix this when opening WhatsApp.</small>
                    </div>
                    <div class="form-group">
                        <label>WhatsApp message template</label>
                        <textarea name="template_whatsapp_message" class="form-control" rows="4" placeholder="Message..."><?php echo e($settings['template_whatsapp_message'] ?? '', false); ?></textarea>
                    </div>
                    <div class="form-group">
                        <label>Email message template</label>
                        <textarea name="template_email_message" class="form-control" rows="4" placeholder="Message..."><?php echo e($settings['template_email_message'] ?? '', false); ?></textarea>
                    </div>

                    <h4 style="margin-top:18px;">Delete Notifications</h4>
                    <div class="form-group">
                        <label>Delete WhatsApp template</label>
                        <textarea name="template_delete_whatsapp_message" class="form-control" rows="4" placeholder="Use tokens: {actor}, {entity}, {entity_id}, {mosque}, {business}, {date}"><?php echo e($settings['template_delete_whatsapp_message'] ?? '', false); ?></textarea>
                    </div>
                    <div class="form-group">
                        <label>Delete email subject</label>
                        <input type="text" name="template_delete_email_subject" class="form-control" value="<?php echo e($settings['template_delete_email_subject'] ?? '', false); ?>" placeholder="Delete Notification: {entity} #{entity_id}">
                    </div>
                    <div class="form-group">
                        <label>Delete email template</label>
                        <textarea name="template_delete_email_message" class="form-control" rows="5" placeholder="Use tokens: {actor}, {entity}, {entity_id}, {details}, {mosque}, {business}, {date}"><?php echo e($settings['template_delete_email_message'] ?? '', false); ?></textarea>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-12 text-right">
                    <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('messages.save'); ?></button>
                </div>
            </div>
        </form>
    <?php echo $__env->renderComponent(); ?>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script>
    $(function () {
        function ccToFlagEmoji(cc) {
            if (!cc || cc.length !== 2) {
                return '';
            }
            var A = 0x1F1E6;
            var offset = 0x41;
            cc = cc.toUpperCase();
            return String.fromCodePoint(A + cc.charCodeAt(0) - offset) + String.fromCodePoint(A + cc.charCodeAt(1) - offset);
        }

        function formatCountry(option) {
            if (!option.id) {
                return option.text;
            }
            var cc = option.id;
            if (option.element && option.element.dataset && option.element.dataset.cc) {
                cc = option.element.dataset.cc;
            }
            var flag = ccToFlagEmoji(cc);
            return $('<span>' + flag + ' ' + option.text + '</span>');
        }

        $('#mosque_country').select2({
            width: '100%',
            templateResult: formatCountry,
            templateSelection: formatCountry
        });

        $('#mosque_timezone, #mosque_currency_id').select2({ width: '100%' });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('mosque::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/procharmate/public_html/serial.procharmate.com/Modules/Mosque/Providers/../Resources/views/settings/index.blade.php ENDPATH**/ ?>