<?php

namespace App\Exports;

use App\Models\CaptureItem;
use Carbon\Carbon;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;


class CaptureItemExport implements FromCollection, WithHeadings
{
    public function __construct($captureItem_id)
    {
        $data = [];
        $ci = CaptureItem::where('id', '=', $captureItem_id)->first();
        $ciData = json_decode($ci->data);
        $this->headers = [];
        foreach ($ciData as $key => $value) {
            array_push($this->headers, $key);
            $data[$key] = $value;
        }
        array_push($this->headers, 'created_at');
        $data['created_at'] = $ci->created_at;
        $temp = '['.json_encode($data).']';
        $data = json_decode($temp);
        $this->captureItems = $data;
    }

    public function collection()
    {
        return collect($this->captureItems);
    }
  
    public function headings(): array
    {
        return $this->headers;
    }
}