<?php

namespace App\Exports;

use App\Helpers\Helpers;
use App\Models\ContactGroup;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;


class GroupExport implements FromCollection, WithHeadings
{
    public function __construct($sender)
    {
        $data = [];
        $groups = ContactGroup::where('sender', '=', $sender)->get();
        $i = 0;
        foreach ($groups as $group) {
            $i += 1;
            $arr = ['id' => $i, 'name' => Helpers::sanitize($group->subject), 'phone' => $group->groupId];
            array_push($data, $arr);
        }
        $this->groups = $data;
    }

    public function collection()
    {
        return collect($this->groups);
    }
  
    public function headings(): array
    {
        return ['id','name','phone'];
    }
}