<?php

namespace App\Exports;

use App\Models\Message;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;


class MessageExport implements FromCollection, WithHeadings
{
    public function __construct($listAll)
    {
        if ($listAll) {
            $this->transactions = Message::latest()->get();
        } else {
            $this->transactions = Message::where('user_id', '=', auth()->user()->id)->latest()->get();
        }
    }

    public function collection()
    {
        return collect($this->transactions);
    }
  
    public function headings(): array
    {
        return ['id', 'user_id', 'sender', 'msgtext', 'mediaurl', 'key_remoteJid', 'key_fromMe', 'key_id', 'messageTimestamp', 'pushName', 'broadcast', 'message', 'created_at', 'updated_at'];
    }
}