<?php

namespace App\Exports;

use App\Models\Outbox;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class OutboxExport implements FromCollection, WithHeadings
{
    protected $status;

    function __construct($job_id, $status) {
        $this->job_id = $job_id;
        $this->status = $status;
    }

    public function collection()
    {
        if (!empty($this->job_id) && !empty($this->status)) {
            return Outbox::where('user_id', '=', auth()->user()->id)->where('job_id', '=', $this->job_id)->where('status', 'like', "$this->status%")->get();
        } else if (!empty($this->job_id)) {
            return Outbox::where('user_id', '=', auth()->user()->id)->where('job_id', '=', $this->job_id)->get();
        } else if (!empty($this->status)) {
            return Outbox::where('user_id', '=', auth()->user()->id)->where('status', 'like', "$this->status%")->get();
        } else {
            return Outbox::where('user_id', '=', auth()->user()->id)->orderBy('job_id', 'asc')->get();
        }
    }
  
    public function headings(): array
    {
        return ['id', 'user_id', 'job_id', 'sender', 'receiver', 'rec_name', 'msgtext', 'data', 'mediaurl', 'schedule', 'msgdelay', 'status', 'recurring', 'created_at','updated_at'];
    }
}