<?php

namespace App\Exports;

use App\Models\ContactGroup;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;


class ParticipantExport implements FromCollection, WithHeadings
{
    public function __construct($id)
    {
        $data = [];
        $contactGroup = ContactGroup::where('id', '=', $id)->first();
        $i = 0;
        $participants = json_decode($contactGroup->participants);
        foreach ($participants as $participant) {
            $i += 1;
            $arr = ['id' => $i, 'name' => __('Sir/Madam'), 'phone' => preg_replace('/\D/', '', $participant->id)];
            array_push($data, $arr);
        }
        $this->participants = $data;
    }

    public function collection()
    {
        return collect($this->participants);
    }
  
    public function headings(): array
    {
        return ['id','name','phone'];
    }
}