<?php

namespace App\Exports;

use App\Models\Subscriber;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;


class SubscriberExport implements FromCollection, WithHeadings
{
    public function __construct()
    {
        $this->transactions = Subscriber::where('user_id', '=', auth()->user()->id)->latest()->get();
    }

    public function collection()
    {
        return collect($this->transactions);
    }
  
    public function headings(): array
    {
        return ['id', 'user_id', 'sender', 'name', 'phone', 'status', 'created_at', 'updated_at'];
    }
}