<?php

namespace App\Exports;

use Formatter;
use App\Models\Transaction;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;


class TransactionExport implements FromCollection, WithHeadings
{
    public function __construct()
    {
        $this->transactions = Transaction::where('user_id', '=', auth()->user()->id)->latest()->get();
    }

    public function collection()
    {
        return collect($this->transactions);
    }
  
    public function headings(): array
    {
        return ['id','code','user_id', 'user2_id','type','amount', 'memo', 'confirmed', 'data', 'created_at', 'updated_at'];
    }
}