<?php

namespace App\Http\Controllers;

use App\Helpers\Helpers as Helpers;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\CaptureItemExport;
use App\Exports\CaptureSubjectExport;
use App\Models\CaptureItem;
use Illuminate\Http\Request;

class CaptureController extends Controller
{
    public function list()
    {
        $user = auth()->user();
        $captureItems = $user->capture_items()->orderBy('id', 'desc')->get();
        $filePath = Helpers::filePath($user->id, 'subjects.json');
        $contents = null;
        $subjects = null;
        if (file_exists($filePath)) {
            $contents = file_get_contents($filePath);
            $subjects = json_decode($contents);
        }
        return view('/capture-list', compact('user', 'captureItems', 'contents', 'subjects'));
    }

    public function update(Request $request)
    {
        $user = auth()->user();
        $captureItem = CaptureItem::where('id', '=', $request->input('captureItem_id'))->first();
        if ($user->id != $captureItem->user_id && $user->role !== 'admin') return redirect()->back()->with(['danger_alert' => __('You are not allowed to update Capture item')]);
        $captureItem->subject = $request->input('subject');
        $captureItem->data = $request->input('data');
        $captureItem->save();
        return redirect()->back()->with(['success_alert' => __('Successfully update Capture item') . ': ' . $captureItem->name]);
    }

    public function saveSubjects(Request $request)
    {
        $user = auth()->user();
        if ($user->id != $request->user_id && $user->role !== 'admin') return redirect()->back()->with(['danger_alert' => __('You are not allowed to update Capture subject')]);
        foreach($request->subjects as $subject) {
            $data[strtolower($subject['subject'])] = json_decode($subject['questions']);
        }
        $filePath = Helpers::filePath($user->id, 'subjects.json');
        file_put_contents($filePath, json_encode($data));
        return redirect()->back()->with(['success_alert' => __('Successfully update Capture subject')]);
    }

    public function resetSubjects(Request $request)
    {
        $user = auth()->user();
        if ($user->id != $request->user_id && $user->role !== 'admin') return redirect()->back()->with(['danger_alert' => __('You are not allowed to reset Subjects')]);
        if (file_exists(public_path("users/{$user->id}/assets/subjects.json"))) unlink(public_path("users/{$user->id}/assets/subjects.json"));
        return redirect()->back()->with(['success_alert' => __('Successfully reset Subjects')]);
    }

    public function exportSubject(Request $request)
    {
        return Excel::download(new CaptureSubjectExport($request->captureSubject), 'captureSubject.xlsx');
    }

    public function exportItem(Request $request)
    {
        return Excel::download(new CaptureItemExport($request->captureItem_id), 'captureItem.xlsx');
    }

    public function destroySubject(Request $request)
    {
        // $user = auth()->user();
        $captureItem = CaptureItem::where('user_id', '=', auth()->user()->id)->where('subject', '=', $request->captureSubject)->delete();
        // if ($user->id != $captureItem->user_id && $user->role !== 'admin') return redirect()->back()->with(['danger_alert' => __('You are not allowed to delete Capture item')]);
        // $captureItem->delete();
        return redirect()->back()->with(['success_alert' => __('Successfully delete Capture subject')]);
    }

    public function destroy(Request $request)
    {
        $user = auth()->user();
        $captureItem = CaptureItem::where('id', '=', $request->captureItem_id)->first();
        if ($user->id != $captureItem->user_id && $user->role !== 'admin') return redirect()->back()->with(['danger_alert' => __('You are not allowed to delete Capture item')]);
        $captureItem->delete();
        return redirect()->back()->with(['success_alert' => __('Successfully delete Capture item')]);
    }
}
