<?php

namespace App\Http\Controllers;

use App\Models\Documentation;
use Illuminate\Http\Request;

class DocumentationController extends Controller
{
    public function index()
    {
        $lang = auth()?->user()?->lang ?? 'us';
        if (!in_array($lang, ['us','id','br'])) $lang = 'us';
        $role = empty(auth()?->user()->role) ? 'user' : auth()->user()->role;
        if ($role === 'admin') {
            $menus = Documentation::where('lang', $lang)->groupBy('topic')->orderBy('id')->get();
            $documentations = Documentation::where('lang', $lang)->groupBy('title')->orderBy('id')->get();
        } else if ($role === 'user') {
            $menus = Documentation::where('role', 'user')->where('lang', $lang)->groupBy('topic')->orderBy('id')->get();
            $documentations = Documentation::where('role', 'user')->where('lang', $lang)->groupBy('title')->orderBy('id')->get();
        }
        return view('/documentation-list', compact('role', 'menus', 'documentations'));
    }

    public function store(Request $request)
    {
        // $documentation = new Documentation();
        // $documentation->role = $request->input('role');
        // // $documentation->lang = $request->input('lang');
        // $documentation->highlight = $request->input('highlight');
        // $documentation->topic = $request->input('topic');
        // $documentation->title = $request->input('title');
        // $documentation->content = $request->input('content');
        // $documentation->save();
        $documentation = Documentation::create($request->all());
        return redirect()->back()->with(['success_alert' => __('Successfully add') . ': ' . $documentation->title]);
    }

    public function edit(Documentation $documentation)
    {
        return view('/documentation-edit', compact('documentation'));
    }

    public function update(Request $request, Documentation $documentation)
    {
        // $documentation->role = $request->input('role');
        // // $documentation->lang = $request->input('lang');
        // $documentation->highlight = $request->input('highlight');
        // $documentation->topic = $request->input('topic');
        // $documentation->title = $request->input('title');
        // $documentation->content = $request->input('content');
        // $documentation->save();
        $documentation->update($request->all());
        return redirect()->back()->with(['success_alert' => __('Successfully edit') . ': ' . $documentation->title]);
    }
}
