<?php

namespace App\Http\Controllers;

use App\Helpers\Helpers;
use Module;
use ZipArchive;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
// use Illuminate\Support\Facades\Http;

class ModuleController extends Controller
{
    public function list()
    {
        $checkZipExtension = extension_loaded('zip');
        $modules = Module::all();
        return view('/module-list', compact('modules', 'checkZipExtension'));
    }

    public function store(Request $request)
    {
        $ext = $request->file->getClientOriginalExtension();
        $size = $request->file->getSize();
        $name = $request->file->getClientOriginalName();
        $path = public_path('app-assets/data/');
        File::ensureDirectoryExists($path, 0755, true);
        if ($ext !== 'zip') {
            return redirect()->back()->with(['danger_alert' => __('Failed. Only ZIP Files are allowed')]);
        } elseif ($size > 20000000) {
            return redirect()->back()->with(['danger_alert' => __('Failed. ZIP file should not be more than 20MB')]);
        } else {
            $zip = new ZipArchive;
            $request->file->move($path, $name);
            $res = $zip->open($path . $name);
            if ($res == TRUE)
            {
                $zip->extractTo(base_path('Modules/'));
                $zip->close();
                File::delete($path . $name);

                return redirect()->back()->with(['success_alert' => __('Successfully install Module')]);
            } else {
                return redirect()->back()->with(['danger_alert' => __('Failed. ZIP could not be extracted. Try again')]);
            }
        }
    }

    public function enable(Request $request) 
    {
        Module::find($request->module_name)->enable();
        return redirect()->back()->with(['success_alert' => __('Successfully enable Module')]);
    }

    public function disable(Request $request) 
    {
        Module::find($request->module_name)->disable();
        return redirect()->back()->with(['success_alert' => __('Successfully disable Module')]);
    }

    public function destroy(Request $request)
    {
        Module::find($request->module_name)->delete();
        return redirect()->back()->with(['success_alert' => __('Successfully delete Module')]);
    }
}
