<?php

namespace App\Http\Controllers;

use App\Models\Package;
use Illuminate\Http\Request;

class PackageController extends Controller
{
  public function list()
  {
    $packages = Package::all();
    return view('/package-list', compact('packages'));
  }

  public function store(Request $request)
  {
    $package = new Package();
    $package->name = $request->input('name');
    $package->description = $request->input('description');
    $package->rate_monthly = $request->input('rate_monthly');
    $package->rate_yearly = 10 * $request->input('rate_monthly'); //$request->input('rate_yearly');
    $package->max_outgoing = $request->input('max_outgoing');
    $package->max_device = $request->input('max_device');
    $package->max_autoreply = $request->input('max_autoreply');
    $package->max_phonebook = $request->input('max_phonebook');
    $package->global_senders = $request->input('global_senders');
    $package->webhook = $request->input('webhook');
    $package->footer = $request->input('footer');
    $package->save();
    return redirect()
      ->back()
      ->with(['success_alert' => __('Successfully add') . ': ' . $package->name]);
  }

  public function update(Request $request, Package $package)
  {
    $package = Package::where('id', '=', $request->input('package_id'))->first();
    $package->name = $request->input('name');
    $package->description = $request->input('description');
    $package->rate_monthly = $request->input('rate_monthly');
    $package->rate_yearly = 10 * $request->input('rate_monthly'); //$request->input('rate_yearly');
    $package->max_outgoing = $request->input('max_outgoing');
    $package->max_device = $request->input('max_device');
    $package->max_autoreply = $request->input('max_autoreply');
    $package->max_phonebook = $request->input('max_phonebook');
    $package->global_senders = $request->input('global_senders');
    $package->hidden = $request->input('hidden');
    $package->webhook = $request->input('webhook');
    $package->footer = $request->input('footer');
    $package->save();
    return redirect()
      ->back()
      ->with(['success_alert' => __('Successfully update Package') . ': ' . $package->name]);
  }

  public function destroy(Request $request)
  {
    $package = Package::where('id', '=', $request->package_id)->delete();
    return redirect()
      ->back()
      ->with(['success_alert' => __('Successfully delete Package')]);
  }
}
