<?php

namespace App\Http\Controllers;

use App\Helpers\Helpers;
use Illuminate\Http\Request;

class RestApiController extends Controller
{
    public function index(Request $request)
    {
        $appurl = rtrim(config('app.url'), '/');
        $nodeurl = rtrim(config('app.node_url'), '/');
        $receiver = '2348136666556';
        $msgtext = 'Testing send message through API';
        $msgtext2 = 'Testing+send+message+through+API';
        $msglocation = 'degreesLatitude:24.232483,degreesLongitude:55.692107,locationName:Omar+Palace,locationAddress:Abu+Dhabi';
        $msgvcard = 'FN:My+Full+Name,ORG:My+Company+Name,TEL:2348136666556,EMAIL:email%40domain.com,ADR:;;123+Main+St;City;State;12345;Country';
        $device = auth()->user()->devices()->where('status', 'ONLINE')->first();
        if (empty($device->sender)) {
            $sender = 'PLEASE_ADD_SENDER_FIRST';
            $token = 'PLEASE_ADD_SENDER_FIRST';
        } else {
            $sender = $device->sender;
            $token = $device->token;
        }
        $mediaurl = Helpers::setting('logoUrl');

        $sendget = str_replace(['#nodeurl', '#receiver', '#msgtext2', '#token', '#mediaurl'], [$nodeurl, $receiver, $msgtext2, $token, $mediaurl], file_get_contents(public_path('app-assets/data/restsendget.txt')));

        $sendpost = str_replace(['#appurl', '#nodeurl', '#receiver', '#msgtext', '#token', '#mediaurl'], [$appurl, $nodeurl, $receiver, $msgtext, $token, $mediaurl], file_get_contents(public_path('app-assets/data/restsendpost.txt')));

        $getqrget = str_replace(['#nodeurl', '#receiver', '#token'], [ $nodeurl, $receiver, $token], file_get_contents(public_path('app-assets/data/restgetqrget.txt')));

        $onwaget = str_replace(['#nodeurl', '#receiver', '#token'], [ $nodeurl, $receiver, $token], file_get_contents(public_path('app-assets/data/restonwaget.txt')));

        $onwapost = str_replace(['#nodeurl', '#receiver', '#token'], [$nodeurl, $receiver, $token], file_get_contents(public_path('app-assets/data/restonwapost.txt')));

        $fetchgroupsget = str_replace(['#nodeurl', '#sender', '#token'], [ $nodeurl, $sender, $token], file_get_contents(public_path('app-assets/data/restfetchgroupsget.txt')));

        $fetchgroupspost = str_replace(['#nodeurl', '#sender', '#token'], [$nodeurl, $sender, $token], file_get_contents(public_path('app-assets/data/restfetchgroupspost.txt')));

        $locationget = str_replace(['#nodeurl', '#receiver', '#msglocation', '#token'], [$nodeurl, $receiver, $msglocation, $token], file_get_contents(public_path('app-assets/data/restlocationget.txt')));

        $locationpost = str_replace(['#nodeurl', '#receiver', '#msglocation', '#token'], [$nodeurl, $receiver, $msglocation, $token], file_get_contents(public_path('app-assets/data/restlocationpost.txt')));

        $pollpost = str_replace(['#nodeurl', '#receiver', '#token'], [$nodeurl, $receiver, $token], file_get_contents(public_path('app-assets/data/restpollpost.txt')));

        $vcardget = str_replace(['#nodeurl', '#receiver', '#msgvcard', '#token'], [$nodeurl, $receiver, $msgvcard, $token], file_get_contents(public_path('app-assets/data/restvcardget.txt')));

        $vcardpost = str_replace(['#nodeurl', '#receiver', '#msgvcard', '#token'], [$nodeurl, $receiver, $msgvcard, $token], file_get_contents(public_path('app-assets/data/restvcardpost.txt')));

        $cronjob = str_replace(['#base_path'], [base_path()], file_get_contents(public_path('app-assets/data/restcronjob.txt')));

        return view('restapi', compact('sendget', 'sendpost', 'getqrget', 'onwaget', 'onwapost', 'fetchgroupsget', 'fetchgroupspost', 'locationget', 'locationpost', 'pollpost', 'vcardget', 'vcardpost', 'cronjob'));
    }
}
