<?php

namespace App\Http\Controllers;

use App\Helpers\Helpers;
use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Filesystem\Filesystem;

class SettingController extends Controller
{
  public function list()
  {
    $settings = Setting::where('key', 'NOT LIKE', 'awg_%')->orderBy('key')->get();
    $gateways = \App\Models\PaymentGateway::orderBy('sort_order')->get();
    return view('/setting-list', compact('settings', 'gateways'));
  }

  public function store(Request $request)
  {
    $setting = new Setting();
    $setting->key = $request->input('key');
    if (Setting::where('key', '=', $setting->key)->count() > 0) {
      return redirect()->back()->with(['danger_alert' => __('Duplicate found. Failed to add') . ': ' . $setting->key]);
    }
    $setting->value = rtrim($request->input('value'), '/');
    $setting->save();
    return redirect()->back()->with(['success_alert' => __('Successfully add') . ': ' . $setting->key]);
  }

  public function update(Request $request, Setting $setting)
  {
    $setting = Setting::where('id', '=', $request->input('setting_id'))->first();
    $setting->key = $request->input('key');
    $setting->value = rtrim($request->input('value'), '/');
    $setting->save();
    return redirect()->back()->with(['success_alert' => __('Successfully update Settings') . ': ' . $setting->key]);
  }

  public function deleteKey()
  {
    Setting::where('key', 'awg_orderId')->update(['value' => '']);
    return redirect()->back()->with(['success_alert' => __('Successfully delete license key')]);
  }

  public static function clearCache()
  {
    if (file_exists(storage_path('framework/cache/laravel-excel'))) {
      $file = new Filesystem;
      $file->cleanDirectory(storage_path('framework/cache/laravel-excel'));
    }
    if (file_exists(storage_path('logs/laravel.log'))) {
      unlink(storage_path('logs/laravel.log'));
    }
    Artisan::call('optimize:clear');
    return redirect()->back()->with(['success_alert' => __('Successfully clear cache')]);
  }

  public function destroy(Request $request)
  {
    Setting::where('id', '=', $request->setting_id)->delete();
    return redirect()->back()->with(['success_alert' => __('Successfully delete Settings')]);
  }

  public function updateGateway(Request $request, $gateway_id)
  {
    $gateway = \App\Models\PaymentGateway::findOrFail($gateway_id);
    
    // Get existing settings
    $settings = $gateway->settings ?? [];
    
    // Update common fields
    $gateway->public_key = $request->input('public_key');
    $gateway->secret_key = $request->input('secret_key');
    $gateway->webhook_url = $request->input('webhook_url');
    $gateway->is_active = $request->input('is_active', 0);
    
    // Handle gateway-specific settings
    if ($gateway->name === 'offline') {
      $settings['bank_name'] = $request->input('bank_name');
      $settings['account_number'] = $request->input('account_number');
      $settings['account_name'] = $request->input('account_name');
      $settings['instructions'] = $request->input('instructions');
      $settings['require_proof'] = $request->input('require_proof', 1);
    } elseif ($gateway->name === 'paypal') {
      $settings['mode'] = $request->input('mode', 'sandbox');
      $settings['client_id'] = $request->input('client_id');
      $settings['client_secret'] = $request->input('client_secret');
    } elseif ($gateway->name === 'stripe') {
      $settings['test_mode'] = $request->input('test_mode', 1);
      $settings['publishable_key'] = $request->input('publishable_key');
      $settings['secret_key'] = $request->input('stripe_secret_key');
      $settings['webhook_secret'] = $request->input('webhook_secret');
    }
    
    $gateway->settings = $settings;
    $gateway->save();
    
    return redirect()->back()->with(['success_alert' => __('Payment gateway updated successfully')]);
  }
}
