<?php

namespace App\Http\Controllers;

use App\Helpers\Helpers;
use App\Models\Device;
use App\Models\Package;
use Illuminate\Support\Facades\Artisan;

class WelcomeController extends Controller
{
  public function index()
  {
    if (Helpers::isEx()) {
      $packages = Package::select('name', 'rate_monthly', 'max_outgoing', 'max_device', 'max_phonebook', 'max_autoreply', 'global_senders', 'webhook')
        ->where('name', '<>', 'super')
        ->where('name', '<>', 'trial')
        ->get();
    } else {
      $packages = null;
    }

    if (!empty(Helpers::setting('landingPage'))) {
      if (filter_var(filter_var(Helpers::setting('landingPage'), FILTER_SANITIZE_URL), FILTER_VALIDATE_URL)) {
        return redirect()->to(filter_var(Helpers::setting('landingPage'), FILTER_SANITIZE_URL));
      } else if (file_exists(public_path(Helpers::setting('landingPage')))) {
        $base64 = base64_encode($packages);
        return redirect()->to(
          url(
            Helpers::setting('landingPage') .
              '?packages=' .
              $base64 .
              '&currencyCode=' .
              Helpers::setting('currencyCode') .
              '&decimals=' .
              Helpers::setting('nfDecimals') .
              '&decimalPoint=' .
              Helpers::setting('nfDecimalPoint') .
              '&separator=' .
              Helpers::setting('nfSeparator')
          )
        );
      } else if (Helpers::setting('landingPage') === 'login') {
        if (empty(auth()->user()->id)) {
          return view('auth/login');
        } else {
          return redirect()->route('user.show');
        }
      } else {
        return view('/welcome', compact('packages'));
      }
    } else {
      return view('/welcome', compact('packages'));
    }
  }
}
?>
