<?php

namespace App\Http\Middleware;

use Closure;
use App\Helpers\Helpers;
use Carbon\Carbon;
use Illuminate\Support\Facades\Route;

class Active
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (in_array(Route::currentRouteName(), ['user.leaveImpersonate'])) return $next($request);
        if ( $request->user()->role !== 'admin' && Helpers::isEx()) {
            if ((Carbon::now()->diffInseconds($request->user()->billing_end, false)) < 0) {
                return redirect()->route('user.expired', ['name' => $request->user()->name]);
            }
        }
        return $next($request);
    }
}
