<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Route;

class Banned
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (in_array(Route::currentRouteName(), ['user.leaveImpersonate'])) return $next($request);
        if (auth()->user() && auth()->user()->banned) return redirect()->route('user.banned');
        return $next($request);
    }
}
