<?php

namespace App\Http\Middleware;

use Closure;

class Demo
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (config('app.DEMO') && auth()->user()->id != 1) {
            return redirect()->back()->with(['danger_alert' => 'Not allowed in DEMO mode.']);
        }
        return $next($request);
    }
}
