<?php
  
namespace App\Imports;
  
use App\Models\PbTemp;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
  
class PhonebookImport implements ToModel, WithHeadingRow
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        return new PbTemp([
            'name'  => !empty($row['name']) ? (string)$row['name'] : '',
            'phone' => !empty($row['phone']) ? (string)$row['phone'] : '',
            'email'  => !empty($row['email']) ? (string)$row['email'] : '',
            'memo'  => !empty($row['memo']) ? (string)$row['memo'] : '',
            'column1'  => !empty($row['column1']) ? (string)$row['column1'] : '',
            'column2'  => !empty($row['column2']) ? (string)$row['column2'] : '',
            'column3'  => !empty($row['column3']) ? (string)$row['column3'] : '',
            'column4'  => !empty($row['column4']) ? (string)$row['column4'] : '',
            'column5'  => !empty($row['column5']) ? (string)$row['column5'] : '',
        ]);
    }
}