<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ChatbotConversation extends Model
{
    use HasFactory;

    protected $fillable = [
        'chatbot_session_id',
        'user_message',
        'bot_response',
        'intent',
        'confidence',
    ];

    protected $casts = [
        'confidence' => 'decimal:2',
    ];

    public function session()
    {
        return $this->belongsTo(ChatbotSession::class, 'chatbot_session_id');
    }
}
