<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ChatbotIntent extends Model
{
    use HasFactory;

    protected $fillable = [
        'chatbot_id',
        'pattern',
        'response',
        'category',
        'priority',
        'is_active',
        'keywords',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'keywords' => 'array',
        'priority' => 'integer',
    ];

    public function chatbot()
    {
        return $this->belongsTo(Chatbot::class);
    }

    /**
     * Scope to get only active intents
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Scope to order by priority
     */
    public function scopeByPriority($query)
    {
        return $query->orderBy('priority', 'desc');
    }
}
