<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ChatbotSession extends Model
{
    use HasFactory;

    protected $fillable = [
        'chatbot_id',
        'phone',
        'session_id',
        'context',
        'current_state',
        'last_activity',
    ];

    protected $casts = [
        'context' => 'array',
        'last_activity' => 'datetime',
    ];

    public function chatbot()
    {
        return $this->belongsTo(Chatbot::class);
    }

    public function conversations()
    {
        return $this->hasMany(ChatbotConversation::class);
    }
}
