<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Nicolaslopezj\Searchable\SearchableTrait;

class Device extends Model
{
    use HasFactory, SearchableTrait;

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function contact_groups()
    {
        return $this->hasMany(ContactGroup::class, 'sender', 'sender');
    }

    public function captures()
    {
        return $this->hasMany(Capture::class);
    }

    public function messages()
    {
        return $this->hasMany(Message::class, 'sender', 'sender');
    }

    public function outboxes()
    {
        return $this->hasMany(Outbox::class, 'sender', 'sender');
    }

    public function subscribers()
    {
        return $this->hasMany(Subscriber::class, 'sender', 'sender');
    }

    public function staff()
    {
        return $this->hasMany(Staff::class);
    }

    protected $fillable = [
        'user_id',
        'name',
        'sender',
        'token',
        'status',
        'busy',
        'autoread',
        'autoswitch',
        'warmingup',
        'wu_receiver',
        'subscribe_keyword',
        'unsubscribe_keyword',
        'subscribe_message',
        'unsubscribe_message',
        'autoreply_group',
        'autoreply_pause',
        'autoreply_resume',
        'autoreply_reset',
        'autoreply_pause_msg',
        'autoreply_resume_msg',
        'autoreply_reset_msg',
        'incall_msg',
        'welcome_msg',
        'welcome_cust',
        'idle',
        'webhook',
        'ext_webhook',
        'openai',
        'working_hours',
    ];

    protected $searchable = [
        /**
         * Columns and their priority in search results.
         * Columns with higher values are more important.
         * Columns with equal values have equal importance.
         *
         * @var array
         */
        'columns' => [
            'devices.name' => 10,
            'devices.sender' => 9,
        ],
    ];
}
