<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Nicolaslopezj\Searchable\SearchableTrait;

class Message extends Model
{
    use HasFactory, SearchableTrait;

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function device()
    {
        return $this->belongsTo(Device::class, 'sender', 'sender');
    }

    protected $searchable = [
        /**
         * Columns and their priority in search results.
         * Columns with higher values are more important.
         * Columns with equal values have equal importance.
         *
         * @var array
         */
        'columns' => [
            'messages.sender' => 10,
            'messages.key_remoteJid' => 7,
            'messages.msgtext' => 9,
            'messages.key_id' => 8,
            'messages.pushName' => 7,
        ],
    ];
}
