<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PaymentLog extends Model
{
    use HasFactory;

    public $timestamps = false;

    protected $fillable = [
        'transaction_id',
        'gateway',
        'event_type',
        'request_data',
        'response_data',
        'status',
        'ip_address'
    ];

    protected $casts = [
        'request_data' => 'array',
        'response_data' => 'array',
        'created_at' => 'datetime'
    ];

    /**
     * Related transaction
     */
    public function transaction()
    {
        return $this->belongsTo(Transaction::class);
    }

    /**
     * Related gateway
     */
    public function gateway()
    {
        return $this->belongsTo(PaymentGateway::class, 'gateway', 'name');
    }

    /**
     * Log a payment event
     */
    public static function logEvent($gateway, $eventType, $requestData, $responseData, $status, $transactionId = null)
    {
        return self::create([
            'transaction_id' => $transactionId,
            'gateway' => $gateway,
            'event_type' => $eventType,
            'request_data' => $requestData,
            'response_data' => $responseData,
            'status' => $status,
            'ip_address' => request()->ip()
        ]);
    }
}
