<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Lab404\Impersonate\Models\Impersonate;
use Laravel\Sanctum\HasApiTokens;
use Nicolaslopezj\Searchable\SearchableTrait;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, Impersonate, SearchableTrait;

    public function autoreplies()
    {
        return $this->hasMany(Autoreply::class);
    }

    public function captures()
    {
        return $this->hasMany(Capture::class);
    }

    public function capture_items()
    {
        return $this->hasMany(CaptureItem::class);
    }

    public function devices()
    {
        return $this->hasMany(Device::class);
    }

    public function staff()
    {
        return $this->hasMany(Staff::class);
    }

    public function messages()
    {
        return $this->hasMany(Message::class);
    }

    public function outboxes()
    {
        return $this->hasMany(Outbox::class);
    }

    public function package()
    {
      return $this->belongsTo(Package::class);
    }
    
    public function phonebooks()
    {
        return $this->hasMany(Phonebook::class);
    }

    public function subscribers()
    {
        return $this->hasMany(Subscriber::class);
    }

    public function templates()
    {
        return $this->hasMany(Template::class);
    }

    public function transactions()
    {
        return $this->hasMany(Transaction::class);
    }

    protected $searchable = [
        /**
         * Columns and their priority in search results.
         * Columns with higher values are more important.
         * Columns with equal values have equal importance.
         *
         * @var array
         */
        'columns' => [
            'users.id' => 10,
            'users.name' => 9,
            'users.email' => 8,
            'users.phone' => 7,
        ],
    ];
    
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'phone',
        'password',
        'role',
        'status',
        'lang',
        'rtl',
        'theme',
        'package_id',
        'trial_period',
        'billing_interval',
        'current_sent',
        'total_sent',
        'ip_address',
        'banned',
        'webhook',
        'otp',
        'remember_token',
        'billing_start',
        'billing_end',
        'email_verified_at',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
}
