<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class MessageSentNotification extends Notification
{
    use Queueable;

    protected $message;
    protected $receiver;
    protected $status;

    /**
     * Create a new notification instance.
     */
    public function __construct($message, $receiver, $status)
    {
        $this->message = $message;
        $this->receiver = $receiver;
        $this->status = $status;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database'];
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'message' => $this->message,
            'receiver' => $this->receiver,
            'status' => $this->status,
            'title' => 'Message ' . $this->status,
            'body' => 'Your message to ' . $this->receiver . ' has been ' . strtolower($this->status),
            'icon' => $this->status === 'SENT' ? 'success' : 'error',
        ];
    }
}
