<?php

namespace App\Notifications;

use App\Models\Todo;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Carbon\Carbon;

class TodoReminderNotification extends Notification
{
    use Queueable;

    protected $todo;

    /**
     * Create a new notification instance.
     */
    public function __construct(Todo $todo)
    {
        $this->todo = $todo;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database'];
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        $timeUntil = Carbon::now()->diffForHumans($this->todo->todo_time, true);
        
        return [
            'todo_id' => $this->todo->id,
            'title' => '⏰ Todo Reminder: ' . $this->todo->title,
            'body' => 'Your todo "' . $this->todo->title . '" is scheduled in ' . $timeUntil,
            'todo_title' => $this->todo->title,
            'todo_description' => $this->todo->description,
            'todo_time' => $this->todo->todo_time->format('Y-m-d H:i:s'),
            'todo_time_formatted' => $this->todo->todo_time->format('M d, Y h:i A'),
            'time_until' => $timeUntil,
            'priority' => $this->todo->priority,
            'icon' => 'reminder',
            'url' => route('todo.show', $this->todo->id),
            'action' => 'View Todo',
        ];
    }
}
