<?php

use Illuminate\Support\Facades\Facade;

return [
    'name' => env('APP_NAME', 'NearBuyMarts-API'),
    'version' => '6.1.5',
    'id' => '161824',
    'env' => env('APP_ENV', 'production'),
    'debug' => (bool) env('APP_DEBUG', false),
    'url' => env('APP_URL', 'https://mydomain.com'),
    'node_url' => env('NODE_URL', 'https://api.mydomain.com'),
    'node_port' => env('NODE_PORT', '8000'),
    'asset_url' => env('ASSET_URL'),
    'timezone' => env('APP_TIMEZONE', 'UTC'),
    'default_country_code' => env('DEFAULT_COUNTRY_CODE', 'NG'),
    'theme' => env('APP_THEME', 'light-layout'),
    'locale' => env('APP_LANG', 'us'),
    'fallback_locale' => 'en',
    'faker_locale' => 'en_US',
    'key' => env('APP_KEY'),
    'cipher' => 'AES-256-CBC',
    'DEMO' => (bool) env('DEMO', false),
    'MOBILE' => (bool) env('MOBILE', false),
    // 'GET_VERSION' => env('GET_VERSION', 'https://visimisi.net/api/get-version?id=137540'),
    // 'URL_MAIN' => env('URL_MAIN', 'https://visimisi.net'),
    // 'URL_MY_ACCOUNT' => env('URL_MY_ACCOUNT', 'https://visimisi.net/my-account'),
    'PAYPAL_SANDBOX' => (bool) env('PAYPAL_SANDBOX', false),

    'providers' => [
        /*
         * Laravel Framework Service Providers...
         */
        Illuminate\Auth\AuthServiceProvider::class,
        Illuminate\Broadcasting\BroadcastServiceProvider::class,
        Illuminate\Bus\BusServiceProvider::class,
        Illuminate\Cache\CacheServiceProvider::class,
        Illuminate\Foundation\Providers\ConsoleSupportServiceProvider::class,
        Illuminate\Cookie\CookieServiceProvider::class,
        Illuminate\Database\DatabaseServiceProvider::class,
        Illuminate\Encryption\EncryptionServiceProvider::class,
        Illuminate\Filesystem\FilesystemServiceProvider::class,
        Illuminate\Foundation\Providers\FoundationServiceProvider::class,
        Illuminate\Hashing\HashServiceProvider::class,
        Illuminate\Mail\MailServiceProvider::class,
        Illuminate\Notifications\NotificationServiceProvider::class,
        Illuminate\Pagination\PaginationServiceProvider::class,
        Illuminate\Pipeline\PipelineServiceProvider::class,
        Illuminate\Queue\QueueServiceProvider::class,
        Illuminate\Redis\RedisServiceProvider::class,
        Illuminate\Auth\Passwords\PasswordResetServiceProvider::class,
        Illuminate\Session\SessionServiceProvider::class,
        Illuminate\Translation\TranslationServiceProvider::class,
        Illuminate\Validation\ValidationServiceProvider::class,
        Illuminate\View\ViewServiceProvider::class,
        /*
         * Package Service Providers...
         */
        Maatwebsite\Excel\ExcelServiceProvider::class,
        Lab404\Impersonate\ImpersonateServiceProvider::class,

        /*
         * Application Service Providers...
         */
        App\Providers\AppServiceProvider::class,
        App\Providers\AuthServiceProvider::class,
        // App\Providers\BroadcastServiceProvider::class,
        App\Providers\EventServiceProvider::class,
        App\Providers\RouteServiceProvider::class,
    ],

    'aliases' => Facade::defaultAliases()->merge([
        'Excel' => Maatwebsite\Excel\Facades\Excel::class,
        'Formatter' => App\Helpers\Formatter::class,
        'Helper' => App\Helpers\Helpers::class,
        'Helpers' => App\Helpers\Helpers::class,
        'Module' => Nwidart\Modules\Facades\Module::class,
    ])->toArray(),

];
