<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('autoreplies')) {
            Schema::create('autoreplies', function (Blueprint $table) {
                $table->id();
                $table->integer('user_id')->unsigned();
                $table->string('sender', 50)->default('all');
                $table->text('keyword')->nullable();
                $table->tinyInteger('match_percent')->default(100);
                $table->text('response')->nullable();
                $table->longText('data')->nullable();
                // $table->string('mediafile', 191)->nullable();
                $table->text('mediaurl')->nullable();
                $table->timestamp('created_at')->useCurrent();
                $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('autoreplies');
    }
};
