<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('devices')) {
            Schema::create('devices', function (Blueprint $table) {
                $table->id();
                $table->integer('user_id')->unsigned()->nullable();
                $table->string('name', 50)->nullable();
                $table->string('sender', 50)->nullable();
                $table->string('token', 64)->nullable();
                $table->string('status', 20)->nullable()->default('OFFLINE');
                $table->boolean('busy')->nullable()->default(0);
                $table->boolean('autoread')->nullable()->default(0);
                $table->boolean('autoswitch')->nullable()->default(1);
                $table->boolean('warmingup')->nullable()->default(0);
                $table->string('wu_receiver')->nullable();
                $table->string('subscribe_keyword')->nullable();
                $table->string('unsubscribe_keyword')->nullable();
                $table->text('subscribe_message')->nullable();
                $table->text('unsubscribe_message')->nullable();
                $table->boolean('autoreply_group')->nullable()->default(0);
                $table->string('autoreply_pause', 50)->nullable()->default('P');
                $table->string('autoreply_resume', 50)->nullable()->default('R');
                $table->string('autoreply_reset', 50)->nullable()->default('M');
                $table->text('autoreply_pause_msg')->nullable();
                $table->text('autoreply_resume_msg')->nullable();
                $table->text('autoreply_reset_msg')->nullable();
                $table->text('incall_msg')->nullable();
                $table->text('welcome_msg')->nullable();
                $table->json('welcome_cust')->nullable();
                $table->smallInteger('idle')->unsigned()->nullable()->default(0);
                $table->text('webhook')->nullable();
                $table->json('ext_webhook')->nullable();
                $table->json('openai')->nullable();
                $table->json('working_hours')->nullable();
                $table->timestamp('created_at')->useCurrent();
                $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('devices');
    }
};
