<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('documentations')) {
            Schema::create('documentations', function (Blueprint $table) {
                $table->increments('id');
                $table->string('role', 20)->nullable()->default('user');
                $table->string('lang', 20)->default('us');
                $table->string('highlight', 20)->nullable();
                $table->string('topic', 100)->nullable()->default('Features');
                $table->string('title', 100)->nullable();
                $table->text('content')->nullable();
                $table->dateTime('created_at')->useCurrent();
                $table->dateTime('updated_at')->useCurrent()->useCurrentOnUpdate();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('documentations');
    }
};
