<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('outboxes')) {
            Schema::create('outboxes', function (Blueprint $table) {
                $table->id();
                $table->integer('user_id')->unsigned();
                $table->string('job_id', 50)->nullable();
                $table->string('sender', 50)->nullable();
                $table->string('receiver', 50)->nullable();
                $table->string('rec_name', 50)->nullable();
                $table->text('msgtext')->nullable();
                $table->longText('data')->nullable();
                // $table->string('mediafile', 191)->nullable();
                $table->text('mediaurl')->nullable();
                $table->timestamp('schedule')->useCurrent();
                $table->smallInteger('msgdelay')->unsigned()->default(0);
                $table->string('status', 50)->default('PENDING')->comment('PENDING, SENT, FAILED');
                $table->string('recurring', 20)->nullable();
                $table->timestamp('created_at')->useCurrent();
                $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('outboxes');
    }
};
