<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  /**
   * Run the migrations.
   *
   * @return void
   */
  public function up()
  {
    if (!Schema::hasTable('packages')) {
      Schema::create('packages', function (Blueprint $table) {
        $table->id();
        $table->string('name', 50)->nullable();
        $table->string('description', 191)->nullable();
        $table->decimal('rate_monthly', 20, 2)->default(0);
        $table->decimal('rate_yearly', 20, 2)->default(0);
        $table->integer('max_outgoing')->default(-1);
        $table->integer('max_device')->default(-1);
        $table->integer('max_autoreply')->default(-1);
        $table->integer('max_phonebook')->default(-1);
        $table->boolean('global_senders')->default(0);
        $table->boolean('webhook')->default(0);
        $table->boolean('hidden')->default(0);
        $table->text('footer')->nullable();
        $table->timestamp('created_at')->useCurrent();
        $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
      });
    }
  }

  /**
   * Reverse the migrations.
   *
   * @return void
   */
  public function down()
  {
    Schema::dropIfExists('packages');
  }
};
