<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('messages')) {
            Schema::create('messages', function (Blueprint $table) {
                $table->id();
                $table->integer('user_id')->unsigned();
                $table->string('sender', 50)->nullable();
                $table->text('msgtext')->nullable();
                $table->text('mediaurl')->nullable();
                $table->string('key_remoteJid', 50)->nullable();
                $table->boolean('key_fromMe')->default(0);
                $table->string('key_id', 50)->nullable();
                $table->integer('messageTimestamp')->unsigned()->nullable();
                $table->string('pushName', 50)->nullable();
                $table->boolean('broadcast')->nullable();
                $table->json('message')->nullable();
                $table->timestamp('created_at')->useCurrent();
                $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('messages');
    }
};
