<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Update offline payment gateway with proper settings
        DB::table('payment_gateways')
            ->where('name', 'offline')
            ->update([
                'settings' => json_encode([
                    'bank_name' => 'Bank Central Asia',
                    'account_number' => '1234567890',
                    'account_name' => 'Company Name',
                    'instructions' => 'Please make a payment to the bank account above and upload proof of payment. Your wallet will be credited after admin approval.',
                    'require_proof' => true,
                    'logo' => 'offline-payment.png'
                ]),
                'updated_at' => now()
            ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Restore default offline payment settings
        DB::table('payment_gateways')
            ->where('name', 'offline')
            ->update([
                'settings' => json_encode([
                    'instructions' => 'Please contact admin for payment instructions',
                    'bank_details' => 'Bank: [Your Bank]\nAccount: [Your Account]\nAccount Name: [Your Name]',
                    'requires_approval' => true,
                    'logo' => 'offline-payment.png'
                ]),
                'updated_at' => now()
            ]);
    }
};
