<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('outboxes', function (Blueprint $table) {
            $table->boolean('use_device_rotation')->default(false)->after('recurring');
            $table->json('rotation_devices')->nullable()->after('use_device_rotation');
            $table->string('current_rotation_device')->nullable()->after('rotation_devices');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('outboxes', function (Blueprint $table) {
            $table->dropColumn(['use_device_rotation', 'rotation_devices', 'current_rotation_device']);
        });
    }
};
