<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('chatbot_intents', function (Blueprint $table) {
            $table->id();
            $table->foreignId('chatbot_id')->constrained('chatbots')->onDelete('cascade');
            $table->string('pattern'); // The trigger phrase/pattern
            $table->text('response'); // The response message
            $table->string('category')->nullable(); // Category: greeting, faq, support, etc.
            $table->integer('priority')->default(0); // Higher priority intents matched first
            $table->boolean('is_active')->default(true);
            $table->json('keywords')->nullable(); // Additional keywords for matching
            $table->timestamps();
            
            $table->index(['chatbot_id', 'is_active']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('chatbot_intents');
    }
};
