<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('staff', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); // Owner of the device
            $table->foreignId('device_id')->constrained()->onDelete('cascade'); // WhatsApp device
            $table->string('staff_name'); // Name of staff member
            $table->string('staff_email')->unique(); // Email for staff login
            $table->string('staff_phone')->nullable(); // Phone number
            $table->enum('role', ['viewer', 'operator', 'manager'])->default('operator'); // Access level
            $table->json('permissions')->nullable(); // Specific permissions: view_tickets, reply_tickets, manage_contacts, etc.
            $table->enum('status', ['active', 'inactive', 'suspended'])->default('active');
            $table->timestamp('last_login_at')->nullable();
            $table->timestamps();
            
            // Indexes
            $table->index(['user_id', 'device_id']);
            $table->index('status');
            $table->unique(['device_id', 'staff_email']); // Each staff email unique per device
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('staff');
    }
};
