<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('support_tickets', function (Blueprint $table) {
            $table->foreignId('assigned_staff_id')->nullable()->after('assigned_to')->constrained('staff')->onDelete('set null');
            $table->index('assigned_staff_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('support_tickets', function (Blueprint $table) {
            $table->dropForeign(['assigned_staff_id']);
            $table->dropIndex(['assigned_staff_id']);
            $table->dropColumn('assigned_staff_id');
        });
    }
};
