<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
{
    if (!Schema::hasColumn('transactions', 'proof_of_payment')) {
        Schema::table('transactions', function (Blueprint $table) {
            $table->string('proof_of_payment')->nullable()->after('gateway_status');
        });
    }
}

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            // Remove proof_of_payment column
            $table->dropColumn('proof_of_payment');
        });
    }
};
