<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('devices', function (Blueprint $table) {
            // Add columns for WhatsApp profile info if they don't exist
            if (!Schema::hasColumn('devices', 'waid')) {
                $table->string('waid')->nullable()->after('sender');
            }
            if (!Schema::hasColumn('devices', 'waname')) {
                $table->string('waname')->nullable()->after('waid');
            }
            if (!Schema::hasColumn('devices', 'imgurl')) {
                $table->text('imgurl')->nullable()->after('waname');
            }
        });
        
        Schema::table('messages', function (Blueprint $table) {
            // Add from_me column if it doesn't exist
            if (!Schema::hasColumn('messages', 'from_me')) {
                $table->boolean('from_me')->default(false)->after('message');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('devices', function (Blueprint $table) {
            $table->dropColumn(['waid', 'waname', 'imgurl']);
        });
        
        Schema::table('messages', function (Blueprint $table) {
            $table->dropColumn('from_me');
        });
    }
};
