<?php

// ready to use variables (no need to catch these, it is already catched):
// $receiver    //mentioned     // $text        // $sender      // $token
// $appurl      // $nodeurl     // $recname     // $devtype
// $phone       // $keyword     // $key_id      // $mediaurl

// Example how to catch new incoming data:
// $invoiceId  = !empty($request->invoiceId) ? $request->invoiceId : null;

/* If enabled here, need to enable user's webhook to use Subscribe/Unsubscribe feature */
// $this->subUnsub($keyword, $phone, $device, $recname); // If want universal, then enable it on (/app/Http/Controllers/WebhookController.php) and disable this one.

/* If enabled here, need to enable user's webhook to use Capture feature */
// $this->captureWebhook($keyword, $phone, $device, $recname); // If want universal, then enable it on (/app/Http/Controllers/WebhookController.php) and disable this one.

/* START AUTOREPLY WEBHOOK */
switch ($keyword) {
  case 'good morning':
  case 'good afternoon':
  case 'good evening':
    $chatMessage = ['text' => $keyword . ' {name}... How are you today?'];
    $result = ['data' => $chatMessage];
    break;

  case '6 replies': // ONLY supports maximum 6 = 'data' | 'data0' | 'data1' | 'data2' | 'data3' | 'data4'
    $chatMessage1 = ['text' => $keyword . ' {name}... How are you today?'];
    $chatMessage2 = ['text' => 'Hello {name}... This is a message in regular chat mode'];
    $imageMessage1 = [
      'image' => ['url' => 'https://i.ytimg.com/vi/gUIJ-UkQsXI/maxresdefault.jpg'],
      'caption' => 'Hello {name}... this is a webhook picture from the web url',
    ];
    $imageMessage2 = [
      'image' => ['url' => url('/app-assets/images/app/walking.gif')],
      'caption' => 'Hello {name}... this is a webhook picture from local storage',
    ];
    $audioMessage = [
      'audio' => ['url' => 'https://download.samplelib.com/mp3/sample-9s.mp3', 'mimetype' => 'audio/mp4', 'ptt' => true, 'gifPlayback' => true ],
    ];
    $videoMessage = [
      'video' => ['url' => url('/app-assets/images/app/walking.gif')],
      'mimetype' => 'video/mp4',
      'caption' => 'Hello {name}... this is a video from the web url',
      'gifPlayback' => true,
    ];
    $result = [
      'data' => $chatMessage1,
      'data0' => $chatMessage2,
      'data1' => $imageMessage1,
      'data2' => $imageMessage2,
      'data3' => $audioMessage,
      'data4' => $videoMessage,
    ];
    break;

  case '!chat':
    $chatMessage = ['text' => 'Hello {name}... This is a message in regular chat mode'];
    $result = ['data' => $chatMessage];
    break;

  case '!version':
    $chatMessage = ['text' => 'NearBuyMarts-API ' . file_get_contents(base_path('storage/installed'))];
    $result = ['data' => $chatMessage];
    break;

  case '!appurl':
    $chatMessage = ['text' => rtrim(config('app.url'), '/')];
    $result = ['data' => $chatMessage];
    break;

  case '!nodeurl':
    $chatMessage = ['text' => rtrim(config('app.node_url'), '/')];
    $result = ['data' => $chatMessage];
    break;

  case '!image':
    $imageMessage = [
      'image' => ['url' => 'https://i.ytimg.com/vi/gUIJ-UkQsXI/maxresdefault.jpg'],
      'caption' => 'Hello {name}... this is a webhook picture from the web url',
    ];
    $result = ['data' => $imageMessage];
    break;

  case '!gif':
    $imageMessage = [
      'image' => ['url' => url('/app-assets/images/app/walking.gif')],
      'caption' => 'Hello {name}... this is a webhook picture from local storage',
    ];
    $result = ['data' => $imageMessage];
    break;

  case '!audio':
    $audioMessage = [
      'audio' => ['url' => 'https://download.samplelib.com/mp3/sample-9s.mp3', 'mimetype' => 'audio/mp4', 'ptt' => true, 'gifPlayback' => true ],
    ];
    $result = ['data' => $audioMessage];
    break;

  case '!video':
    $videoMessage = [
      'video' => ['url' => url('/app-assets/images/app/walking.gif')],
      'mimetype' => 'video/mp4',
      'caption' => 'Hello {name}... this is a video from the web url',
      'gifPlayback' => true,
    ];
    $result = ['data' => $videoMessage];
    break;
  
  default:
  // if no match, do nothing!
  // if you want a default response if no keyword matched, please read: https://visimisi.net/docs#default-autoreply
}

if (!empty($result)) {
  echo json_encode($result);
  return;
}
/* END AUTOREPLY WEBHOOK */
?>
