# Landing Page Assets

All assets for the landing page are stored locally to ensure availability even without internet connection on your cPanel server.

## Directory Structure

```
landing-assets/
├── css/
│   ├── aos.css                 # Animation On Scroll library
│   ├── bootstrap.min.css       # Bootstrap 5.3.0 framework
│   └── bootstrap-icons.css     # Bootstrap Icons (configured for local fonts)
├── fonts/
│   └── bootstrap-icons.woff2   # Bootstrap Icons font file
├── images/
│   ├── hero-illustration.svg           # Main hero section illustration
│   ├── marketing-automation.svg        # Marketing features illustration
│   ├── team-collaboration.svg          # About us / team illustration
│   ├── features-illustration.svg       # Features section illustration
│   ├── qr-scan.svg                     # QR code scanning illustration
│   ├── create-account.svg              # Account creation illustration
│   └── send-message.svg                # Message sending illustration
└── js/
    ├── aos.js                  # Animation On Scroll JavaScript
    └── bootstrap.bundle.min.js # Bootstrap 5.3.0 with Popper.js
```

## Custom Images Created

All SVG images are:
- ✅ **100% Original** - Created specifically for NearBuy Communications Gateway
- ✅ **Scalable** - Vector graphics that look perfect at any size
- ✅ **Lightweight** - Small file sizes for fast loading
- ✅ **Brand Colors** - Using your primary orange (#FD810E) and green (#25D366)
- ✅ **Corporate Design** - Professional, clean, and modern aesthetic

## Image Descriptions

1. **hero-illustration.svg** - WhatsApp chat interface with floating elements
2. **marketing-automation.svg** - API hub with connected features
3. **team-collaboration.svg** - Team working with analytics dashboard
4. **features-illustration.svg** - Mobile device with feature icons
5. **qr-scan.svg** - QR code scanning interface
6. **create-account.svg** - Sign-up form illustration
7. **send-message.svg** - Bulk message sending concept

## Color Palette Used

- **Primary Orange:** #FD810E
- **Primary Dark:** #E67410
- **Primary Light:** #FF9638
- **WhatsApp Green:** #25D366
- **Dark Blue:** #2C3E50
- **Light Backgrounds:** #F8F9FA, #FFE5CC, #E5F5EB

## Usage in Laravel Blade

All assets are referenced using Laravel's `asset()` helper:

```php
<!-- CSS -->
<link href="{{ asset('landing-assets/css/bootstrap.min.css') }}" rel="stylesheet">
<link href="{{ asset('landing-assets/css/bootstrap-icons.css') }}" rel="stylesheet">
<link href="{{ asset('landing-assets/css/aos.css') }}" rel="stylesheet">

<!-- Images -->
<img src="{{ asset('landing-assets/images/hero-illustration.svg') }}" alt="Hero">

<!-- JavaScript -->
<script src="{{ asset('landing-assets/js/bootstrap.bundle.min.js') }}"></script>
<script src="{{ asset('landing-assets/js/aos.js') }}"></script>
```

## Deployment to cPanel

When uploading to cPanel:

1. Upload the entire `landing-assets` folder to `public_html/`
2. Ensure proper permissions:
   ```bash
   chmod -R 755 public_html/landing-assets
   ```
3. The landing page will work offline with all assets local

## Benefits

✅ **No CDN Dependency** - Works without internet connection
✅ **Faster Loading** - Local files load faster than CDN
✅ **Always Available** - No risk of CDN downtime
✅ **Privacy** - No external tracking from CDN providers
✅ **Consistent Branding** - Custom images match your brand

## License

All custom SVG images are proprietary to NearBuy Communications Gateway.
Third-party libraries (Bootstrap, AOS) retain their original licenses.

---

Created: November 13, 2025
For: https://nearbuymarts.com
