<!DOCTYPE html>
<html class="loading" lang="en" data-textdirection="ltr">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1.0,user-scalable=0,minimal-ui">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ __('Log in') }} - {{ config('app.name') }}</title>
    <link rel="icon" type="image/x-icon" href="{{ url('/') }}/app-assets/images/ico/favicon.ico" />
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600&display=swap" rel="stylesheet">
    
    <!-- BEGIN: Vendor CSS-->
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/vendors/css/vendors.min.css">
    <!-- END: Vendor CSS-->

    <!-- BEGIN: Theme CSS-->
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css/bootstrap.css">
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css/bootstrap-extended.css">
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css/colors.css">
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css/components.css">
    <!-- END: Theme CSS-->

    <!-- BEGIN: Page CSS-->
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css/core/menu/menu-types/vertical-menu.css">
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css/pages/authentication.css">
    <!-- END: Page CSS-->

    <style>
        .auth-wrapper.auth-basic {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .auth-card {
            background: #fff;
            border-radius: 1rem;
            box-shadow: 0 4px 25px 0 rgba(0, 0, 0, 0.1);
            padding: 2.5rem;
        }
        .brand-logo {
            text-align: center;
            margin-bottom: 2rem;
        }
        .brand-logo img {
            max-height: 60px;
            margin-bottom: 1rem;
        }
        .auth-title {
            font-size: 1.5rem;
            font-weight: 600;
            color: #5e5873;
            margin-bottom: 0.5rem;
        }
        .auth-subtitle {
            color: #6e6b7b;
            margin-bottom: 2rem;
        }
        .demo-credentials {
            background: #fff5e6;
            border-left: 3px solid #fd810e;
            padding: 0.75rem;
            margin-bottom: 1rem;
            border-radius: 0.25rem;
            font-size: 0.857rem;
        }
        .demo-credentials strong {
            color: #fd810e;
        }
        .form-label {
            font-weight: 500;
            color: #5e5873;
            margin-bottom: 0.5rem;
        }
        .form-control {
            border-radius: 0.5rem;
            padding: 0.75rem 1rem;
            border: 1px solid #d8d6de;
        }
        .form-control:focus {
            border-color: #fd810e;
            box-shadow: 0 3px 10px 0 rgba(253, 129, 14, 0.1);
        }
        .btn-login {
            background: linear-gradient(135deg, #fd810e 0%, #ff6b35 100%);
            border: none;
            border-radius: 0.5rem;
            padding: 0.75rem 1.5rem;
            color: #fff;
            font-weight: 500;
            width: 100%;
            transition: all 0.3s ease;
        }
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px 0 rgba(253, 129, 14, 0.4);
            color: #fff;
        }
        .divider {
            display: flex;
            align-items: center;
            text-align: center;
            margin: 1.5rem 0;
        }
        .divider::before,
        .divider::after {
            content: '';
            flex: 1;
            border-bottom: 1px solid #d8d6de;
        }
        .divider span {
            padding: 0 1rem;
            color: #6e6b7b;
            font-size: 0.857rem;
        }
        .auth-link {
            color: #fd810e;
            text-decoration: none;
            font-weight: 500;
        }
        .auth-link:hover {
            color: #ff6b35;
            text-decoration: underline;
        }
        .text-register {
            color: #6e6b7b;
        }
        .alert-status {
            border-radius: 0.5rem;
            border-left: 3px solid #28c76f;
        }
        .alert-errors {
            border-radius: 0.5rem;
            border-left: 3px solid #ea5455;
        }
    </style>
</head>

<body class="vertical-layout vertical-menu-modern blank-page navbar-floating footer-static" data-open="click" data-menu="vertical-menu-modern" data-col="blank-page">
    <!-- BEGIN: Content-->
    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row"></div>
            <div class="content-body">
                <div class="auth-wrapper auth-basic px-2">
                    <div class="auth-inner my-2">
                        <div class="auth-card">
                            <!-- Logo -->
                            <div class="brand-logo">
                                @if(\App\Helpers\Helpers::setting('logoUrl'))
                                    <img src="{{ \App\Helpers\Helpers::setting('logoUrl') }}" alt="{{ config('app.name') }}">
                                @else
                                    <h2 class="brand-text text-primary mb-0">{{ config('app.name') }}</h2>
                                @endif
                            </div>

                            <!-- Title -->
                            <h2 class="auth-title text-center">{{ __('Welcome Back!') }} 👋</h2>
                            <p class="auth-subtitle text-center">{{ __('Please sign in to your account and start the adventure') }}</p>

                            <!-- Session Status -->
                            @if (session('status'))
                                <div class="alert alert-success alert-status" role="alert">
                                    <div class="alert-body">
                                        <i data-feather="check-circle" class="me-50"></i>
                                        {{ session('status') }}
                                    </div>
                                </div>
                            @endif

                            <!-- Validation Errors -->
                            @if ($errors->any())
                                <div class="alert alert-danger alert-errors" role="alert">
                                    <div class="alert-body">
                                        <i data-feather="alert-circle" class="me-50"></i>
                                        <strong>{{ __('Whoops!') }}</strong> {{ __('There were some problems with your input.') }}
                                        <ul class="mb-0 mt-1">
                                            @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            @endif

                            <!-- Demo Credentials -->
                            @if(config('app.DEMO'))
                                <div class="demo-credentials">
                                    <strong>{{ __('Demo Credentials') }}:</strong><br>
                                    <small>{{ __('Username') }}: <strong>admin</strong> or <strong>demo</strong></small><br>
                                    <small>{{ __('Password') }}: <strong>password</strong></small>
                                </div>
                            @endif

                            <!-- Login Form -->
                            <form class="auth-login-form mt-2" method="POST" action="{{ route('login') }}">
                                @csrf

                                <!-- Email/Username/Phone -->
                                <div class="mb-1">
                                    <label for="login" class="form-label">{{ __('Email') }} / {{ __('Username') }} / {{ __('Phone') }}</label>
                                    <input type="text" class="form-control" id="login" name="login" 
                                           placeholder="admin@example.com" aria-describedby="login" 
                                           value="{{ old('login') }}" required autofocus />
                                </div>

                                <!-- Password -->
                                <div class="mb-1">
                                    <div class="d-flex justify-content-between">
                                        <label class="form-label" for="password">{{ __('Password') }}</label>
                                        @if (Route::has('password.request'))
                                            <a href="{{ route('password.request') }}" class="auth-link">
                                                <small>{{ __('Forgot Password?') }}</small>
                                            </a>
                                        @endif
                                    </div>
                                    <div class="input-group input-group-merge form-password-toggle">
                                        <input type="password" class="form-control form-control-merge" id="password" 
                                               name="password" placeholder="············" 
                                               aria-describedby="password" required autocomplete="current-password" />
                                        <span class="input-group-text cursor-pointer"><i data-feather="eye"></i></span>
                                    </div>
                                </div>

                                <!-- Remember Me -->
                                <div class="mb-1">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="remember_me" name="remember" />
                                        <label class="form-check-label" for="remember_me">
                                            {{ __('Remember Me') }}
                                        </label>
                                    </div>
                                </div>

                                <!-- Submit Button -->
                                <button type="submit" class="btn btn-login">
                                    {{ __('Log in') }}
                                </button>
                            </form>

                            <!-- Register Link -->
                            @if (\App\Helpers\Helpers::setting('trialPeriod'))
                                <div class="divider">
                                    <span>{{ __('or') }}</span>
                                </div>
                                <p class="text-center mt-2 text-register">
                                    <span>{{ __('New on our platform?') }}</span>
                                    <a href="{{ route('register') }}" class="auth-link">
                                        {{ __('Create an account') }}
                                    </a>
                                </p>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- END: Content-->

    <!-- BEGIN: Vendor JS-->
    <script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
    <!-- END: Vendor JS-->

    <!-- BEGIN: Theme JS-->
    <script src="{{ url('/') }}/app-assets/js/core/app-menu.js"></script>
    <script src="{{ url('/') }}/app-assets/js/core/app.js"></script>
    <!-- END: Theme JS-->

    <script>
        $(window).on('load', function() {
            if (feather) {
                feather.replace({
                    width: 14,
                    height: 14
                });
            }
        });

        // Toggle password visibility
        $('.form-password-toggle .input-group-text').on('click', function(e) {
            e.preventDefault();
            var $this = $(this);
            var input = $this.closest('.input-group').find('input');
            
            if (input.attr('type') === 'password') {
                input.attr('type', 'text');
                $this.html('<i data-feather="eye-off"></i>');
            } else {
                input.attr('type', 'password');
                $this.html('<i data-feather="eye"></i>');
            }
            
            feather.replace({
                width: 14,
                height: 14
            });
        });
    </script>
</body>
</html>
