<!DOCTYPE html>
<html class="loading" lang="en" data-textdirection="ltr">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1.0,user-scalable=0,minimal-ui">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ __('Register') }} - {{ config('app.name') }}</title>
    <link rel="icon" type="image/x-icon" href="{{ url('/') }}/app-assets/images/ico/favicon.ico" />
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600&display=swap" rel="stylesheet">
    
    <!-- BEGIN: Vendor CSS-->
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/vendors/css/vendors.min.css">
    <!-- END: Vendor CSS-->

    <!-- BEGIN: Theme CSS-->
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css/bootstrap.css">
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css/bootstrap-extended.css">
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css/colors.css">
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css/components.css">
    <!-- END: Theme CSS-->

    <!-- BEGIN: Page CSS-->
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css/core/menu/menu-types/vertical-menu.css">
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css/pages/authentication.css">
    <!-- END: Page CSS-->

    <style>
        .lastname {
            opacity: 0;
            position: absolute;
            top: 0;
            left: 0;
            height: 0;
            width: 0;
            z-index: -1;
        }
        .auth-wrapper.auth-basic {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .auth-card {
            background: #fff;
            border-radius: 1rem;
            box-shadow: 0 4px 25px 0 rgba(0, 0, 0, 0.1);
            padding: 2.5rem;
            max-width: 500px;
            margin: 0 auto;
        }
        .brand-logo {
            text-align: center;
            margin-bottom: 2rem;
        }
        .brand-logo img {
            max-height: 60px;
            margin-bottom: 1rem;
        }
        .auth-title {
            font-size: 1.5rem;
            font-weight: 600;
            color: #5e5873;
            margin-bottom: 0.5rem;
        }
        .auth-subtitle {
            color: #6e6b7b;
            margin-bottom: 2rem;
        }
        .form-label {
            font-weight: 500;
            color: #5e5873;
            margin-bottom: 0.5rem;
        }
        .form-control {
            border-radius: 0.5rem;
            padding: 0.75rem 1rem;
            border: 1px solid #d8d6de;
        }
        .form-control:focus {
            border-color: #fd810e;
            box-shadow: 0 3px 10px 0 rgba(253, 129, 14, 0.1);
        }
        .btn-register {
            background: linear-gradient(135deg, #fd810e 0%, #ff6b35 100%);
            border: none;
            border-radius: 0.5rem;
            padding: 0.75rem 1.5rem;
            color: #fff;
            font-weight: 500;
            width: 100%;
            transition: all 0.3s ease;
        }
        .btn-register:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px 0 rgba(253, 129, 14, 0.4);
            color: #fff;
        }
        .divider {
            display: flex;
            align-items: center;
            text-align: center;
            margin: 1.5rem 0;
        }
        .divider::before,
        .divider::after {
            content: '';
            flex: 1;
            border-bottom: 1px solid #d8d6de;
        }
        .divider span {
            padding: 0 1rem;
            color: #6e6b7b;
            font-size: 0.857rem;
        }
        .auth-link {
            color: #fd810e;
            text-decoration: none;
            font-weight: 500;
        }
        .auth-link:hover {
            color: #ff6b35;
            text-decoration: underline;
        }
        .text-login {
            color: #6e6b7b;
        }
        .alert-errors {
            border-radius: 0.5rem;
            border-left: 3px solid #ea5455;
        }
        .form-check-input:checked {
            background-color: #fd810e;
            border-color: #fd810e;
        }
        .form-check-input:focus {
            border-color: #fd810e;
            box-shadow: 0 2px 4px 0 rgba(253, 129, 14, 0.4);
        }
        .input-group-text {
            cursor: pointer;
            border-radius: 0 0.5rem 0.5rem 0;
        }
    </style>
</head>

<body class="vertical-layout vertical-menu-modern blank-page navbar-floating footer-static" data-open="click" data-menu="vertical-menu-modern" data-col="blank-page">
    <!-- BEGIN: Content-->
    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row"></div>
            <div class="content-body">
                <div class="auth-wrapper auth-basic px-2">
                    <div class="auth-inner my-2">
                        <div class="auth-card">
                            <!-- Logo -->
                            <div class="brand-logo">
                                @if(\App\Helpers\Helpers::setting('logoUrl'))
                                    <img src="{{ \App\Helpers\Helpers::setting('logoUrl') }}" alt="{{ config('app.name') }}">
                                @else
                                    <h2 class="brand-text text-primary mb-0">{{ config('app.name') }}</h2>
                                @endif
                            </div>

                            <!-- Title -->
                            <h2 class="auth-title text-center">{{ __('Adventure starts here') }} 🚀</h2>
                            <p class="auth-subtitle text-center">{{ __('Make your app management easy and fun!') }}</p>

                            <!-- Validation Errors -->
                            @if ($errors->any())
                                <div class="alert alert-danger alert-errors" role="alert">
                                    <div class="alert-body">
                                        <i data-feather="alert-circle" class="me-50"></i>
                                        <strong>{{ __('Whoops!') }}</strong> {{ __('There were some problems with your input.') }}
                                        <ul class="mb-0 mt-1">
                                            @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            @endif

                            <!-- Register Form -->
                            <form class="auth-register-form mt-2" method="POST" action="{{ route('register') }}">
                                @csrf

                                <!-- Honeypot -->
                                <div class="lastname">
                                    <label for="lastname">{{ __('Last Name') }}</label>
                                    <input id="lastname" type="text" name="lastname" autocomplete="off" />
                                </div>

                                <!-- Name -->
                                <div class="mb-1">
                                    <label for="name" class="form-label">{{ __('Name') }}</label>
                                    <input type="text" class="form-control" id="name" name="name" 
                                           placeholder="John Doe" value="{{ old('name') }}" required autofocus />
                                </div>

                                <!-- Email -->
                                <div class="mb-1">
                                    <label for="email" class="form-label">{{ __('Email') }}</label>
                                    <input type="email" class="form-control" id="email" name="email" 
                                           placeholder="john@example.com" value="{{ old('email') }}" required />
                                </div>

                                <!-- Phone -->
                                <div class="mb-1">
                                    <label for="phone" class="form-label">{{ __('Phone with country code') }}</label>
                                    <input type="tel" class="form-control" id="phone" name="phone" 
                                           placeholder="+1234567890" value="{{ old('phone') }}" required />
                                </div>

                                <!-- Password -->
                                <div class="mb-1">
                                    <label for="password" class="form-label">{{ __('Password') }}</label>
                                    <div class="input-group input-group-merge form-password-toggle">
                                        <input type="password" class="form-control form-control-merge" id="password" 
                                               name="password" placeholder="············" required autocomplete="new-password" />
                                        <span class="input-group-text cursor-pointer"><i data-feather="eye"></i></span>
                                    </div>
                                </div>

                                <!-- Confirm Password -->
                                <div class="mb-1">
                                    <label for="password_confirmation" class="form-label">{{ __('Confirm Password') }}</label>
                                    <div class="input-group input-group-merge form-password-toggle-confirm">
                                        <input type="password" class="form-control form-control-merge" id="password_confirmation" 
                                               name="password_confirmation" placeholder="············" required />
                                        <span class="input-group-text cursor-pointer"><i data-feather="eye"></i></span>
                                    </div>
                                </div>

                                <!-- Terms -->
                                <div class="mb-1">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="terms-conditions" name="terms" required>
                                        <label class="form-check-label" for="terms-conditions">
                                            {{ __('I agree to') }}
                                            <a href="javascript:void(0);" data-bs-target="#show-terms-conditions" data-bs-toggle="modal" class="auth-link">
                                                {{ __('Terms of Use') }} & {{ __('Privacy Policy') }}
                                            </a>
                                        </label>
                                    </div>
                                </div>

                                <!-- Submit Button -->
                                <button type="submit" class="btn btn-register">
                                    {{ __('Register') }}
                                </button>
                            </form>

                            <!-- Login Link -->
                            <p class="text-center mt-2 text-login">
                                <span>{{ __('Already registered?') }}</span>
                                <a href="{{ route('login') }}" class="auth-link">
                                    {{ __('Sign in instead') }}
                                </a>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- END: Content-->

    <!-- Terms & Conditions Modal -->
    <div class="modal fade" id="show-terms-conditions" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header bg-transparent">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body pb-5 px-sm-5 pt-50">
                    <div class="text-center mb-2">
                        <h3 class="mb-1">{{ __('Terms of Use') }} & {{ __('Privacy Policy') }}</h3>
                    </div>
                    <div class="nav-align-top mb-4">
                        <ul class="nav nav-pills mb-3 nav-fill" role="tablist">
                            <li class="nav-item">
                                <button type="button" class="nav-link active" role="tab" data-bs-toggle="tab"
                                    data-bs-target="#navs-pills-justified-termsofuse"
                                    aria-controls="navs-pills-justified-termsofuse" aria-selected="true">
                                    {{ __('Terms of Use') }}
                                </button>
                            </li>
                            <li class="nav-item">
                                <button type="button" class="nav-link" role="tab" data-bs-toggle="tab"
                                    data-bs-target="#navs-pills-justified-privacypolicy"
                                    aria-controls="navs-pills-justified-privacypolicy" aria-selected="false">
                                    {{ __('Privacy Policy') }}
                                </button>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane fade show active" id="navs-pills-justified-termsofuse" role="tabpanel">
                                <textarea class="form-control" id="termsofuse" rows="15" readonly>{{ file_exists(public_path('app-assets/data/termsofuse.txt')) ? file_get_contents(public_path('app-assets/data/termsofuse.txt')) : 'Rename /public/app-assets/data/termsofuse-example.txt to /public/app-assets/data/termsofuse.txt' }}</textarea>
                            </div>
                            <div class="tab-pane fade" id="navs-pills-justified-privacypolicy" role="tabpanel">
                                <textarea class="form-control" id="privacypolicy" rows="15" readonly>{{ file_exists(public_path('app-assets/data/privacypolicy.txt')) ? file_get_contents(public_path('app-assets/data/privacypolicy.txt')) : 'Rename /public/app-assets/data/privacypolicy-example.txt to /public/app-assets/data/privacypolicy.txt' }}</textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- BEGIN: Vendor JS-->
    <script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
    <!-- END: Vendor JS-->

    <!-- BEGIN: Theme JS-->
    <script src="{{ url('/') }}/app-assets/js/core/app-menu.js"></script>
    <script src="{{ url('/') }}/app-assets/js/core/app.js"></script>
    <!-- END: Theme JS-->

    <script>
        $(window).on('load', function() {
            if (feather) {
                feather.replace({
                    width: 14,
                    height: 14
                });
            }
        });

        // Toggle password visibility
        $('.form-password-toggle .input-group-text').on('click', function(e) {
            e.preventDefault();
            var $this = $(this);
            var input = $this.closest('.input-group').find('input');
            
            if (input.attr('type') === 'password') {
                input.attr('type', 'text');
                $this.html('<i data-feather="eye-off"></i>');
            } else {
                input.attr('type', 'password');
                $this.html('<i data-feather="eye"></i>');
            }
            
            feather.replace({
                width: 14,
                height: 14
            });
        });

        // Toggle confirm password visibility
        $('.form-password-toggle-confirm .input-group-text').on('click', function(e) {
            e.preventDefault();
            var $this = $(this);
            var input = $this.closest('.input-group').find('input');
            
            if (input.attr('type') === 'password') {
                input.attr('type', 'text');
                $this.html('<i data-feather="eye-off"></i>');
            } else {
                input.attr('type', 'password');
                $this.html('<i data-feather="eye"></i>');
            }
            
            feather.replace({
                width: 14,
                height: 14
            });
        });
    </script>
</body>
</html>
