<!DOCTYPE html>
<html class="loading" lang="en" data-textdirection="ltr">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1.0,user-scalable=0,minimal-ui">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ __('Reset Password') }} - {{ config('app.name') }}</title>
    <link rel="icon" type="image/x-icon" href="{{ url('/') }}/app-assets/images/ico/favicon.ico" />
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600&display=swap" rel="stylesheet">
    
    <!-- BEGIN: Vendor CSS-->
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/vendors/css/vendors.min.css">
    <!-- END: Vendor CSS-->

    <!-- BEGIN: Theme CSS-->
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css/bootstrap.css">
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css/bootstrap-extended.css">
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css/colors.css">
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css/components.css">
    <!-- END: Theme CSS-->

    <!-- BEGIN: Page CSS-->
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css/core/menu/menu-types/vertical-menu.css">
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css/pages/authentication.css">
    <!-- END: Page CSS-->

    <style>
        .auth-wrapper.auth-basic {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .auth-card {
            background: #fff;
            border-radius: 1rem;
            box-shadow: 0 4px 25px 0 rgba(0, 0, 0, 0.1);
            padding: 2.5rem;
        }
        .brand-logo {
            text-align: center;
            margin-bottom: 2rem;
        }
        .brand-logo img {
            max-height: 60px;
            margin-bottom: 1rem;
        }
        .auth-title {
            font-size: 1.5rem;
            font-weight: 600;
            color: #5e5873;
            margin-bottom: 0.5rem;
        }
        .auth-subtitle {
            color: #6e6b7b;
            margin-bottom: 2rem;
        }
        .form-label {
            font-weight: 500;
            color: #5e5873;
            margin-bottom: 0.5rem;
        }
        .form-control {
            border-radius: 0.5rem;
            padding: 0.75rem 1rem;
            border: 1px solid #d8d6de;
        }
        .form-control:focus {
            border-color: #fd810e;
            box-shadow: 0 3px 10px 0 rgba(253, 129, 14, 0.1);
        }
        .btn-reset {
            background: linear-gradient(135deg, #fd810e 0%, #ff6b35 100%);
            border: none;
            border-radius: 0.5rem;
            padding: 0.75rem 1.5rem;
            color: #fff;
            font-weight: 500;
            width: 100%;
            transition: all 0.3s ease;
        }
        .btn-reset:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px 0 rgba(253, 129, 14, 0.4);
            color: #fff;
        }
        .alert-errors {
            border-radius: 0.5rem;
            border-left: 3px solid #ea5455;
        }
        .input-group-text {
            cursor: pointer;
            border-radius: 0 0.5rem 0.5rem 0;
        }
        .password-strength {
            margin-top: 0.5rem;
        }
        .password-strength .progress {
            height: 4px;
        }
    </style>
</head>

<body class="vertical-layout vertical-menu-modern blank-page navbar-floating footer-static" data-open="click" data-menu="vertical-menu-modern" data-col="blank-page">
    <!-- BEGIN: Content-->
    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row"></div>
            <div class="content-body">
                <div class="auth-wrapper auth-basic px-2">
                    <div class="auth-inner my-2">
                        <div class="auth-card">
                            <!-- Logo -->
                            <div class="brand-logo">
                                @if(\App\Helpers\Helpers::setting('logoUrl'))
                                    <img src="{{ \App\Helpers\Helpers::setting('logoUrl') }}" alt="{{ config('app.name') }}">
                                @else
                                    <h2 class="brand-text text-primary mb-0">{{ config('app.name') }}</h2>
                                @endif
                            </div>

                            <!-- Title -->
                            <h2 class="auth-title text-center">{{ __('Reset Password') }} 🔐</h2>
                            <p class="auth-subtitle text-center">{{ __('Your new password must be different from previously used passwords') }}</p>

                            <!-- Validation Errors -->
                            @if ($errors->any())
                                <div class="alert alert-danger alert-errors" role="alert">
                                    <div class="alert-body">
                                        <i data-feather="alert-circle" class="me-50"></i>
                                        <strong>{{ __('Whoops!') }}</strong> {{ __('There were some problems with your input.') }}
                                        <ul class="mb-0 mt-1">
                                            @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            @endif

                            <!-- Reset Password Form -->
                            <form class="auth-reset-password-form mt-2" method="POST" action="{{ route('password.update') }}">
                                @csrf

                                <!-- Password Reset Token -->
                                <input type="hidden" name="token" value="{{ $request->route('token') }}">

                                <!-- Email Address -->
                                <div class="mb-1">
                                    <label for="email" class="form-label">{{ __('Email') }}</label>
                                    <input type="email" class="form-control" id="email" name="email" 
                                           value="{{ old('email', $request->email) }}" required autofocus readonly />
                                </div>

                                <!-- New Password -->
                                <div class="mb-1">
                                    <label for="password" class="form-label">{{ __('New Password') }}</label>
                                    <div class="input-group input-group-merge form-password-toggle">
                                        <input type="password" class="form-control form-control-merge" id="password" 
                                               name="password" placeholder="············" required />
                                        <span class="input-group-text cursor-pointer"><i data-feather="eye"></i></span>
                                    </div>
                                    <div class="password-strength mt-1">
                                        <small class="text-muted">{{ __('Use 8 or more characters with a mix of letters, numbers & symbols') }}</small>
                                    </div>
                                </div>

                                <!-- Confirm Password -->
                                <div class="mb-1">
                                    <label for="password_confirmation" class="form-label">{{ __('Confirm Password') }}</label>
                                    <div class="input-group input-group-merge form-password-toggle-confirm">
                                        <input type="password" class="form-control form-control-merge" id="password_confirmation" 
                                               name="password_confirmation" placeholder="············" required />
                                        <span class="input-group-text cursor-pointer"><i data-feather="eye"></i></span>
                                    </div>
                                </div>

                                <!-- Submit Button -->
                                <button type="submit" class="btn btn-reset mt-1">
                                    {{ __('Set New Password') }}
                                </button>
                            </form>

                            <!-- Back to Login -->
                            <p class="text-center mt-2">
                                <a href="{{ route('login') }}" class="auth-link">
                                    <i data-feather="chevron-left" class="me-25"></i>
                                    {{ __('Back to login') }}
                                </a>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- END: Content-->

    <!-- BEGIN: Vendor JS-->
    <script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
    <!-- END: Vendor JS-->

    <!-- BEGIN: Theme JS-->
    <script src="{{ url('/') }}/app-assets/js/core/app-menu.js"></script>
    <script src="{{ url('/') }}/app-assets/js/core/app.js"></script>
    <!-- END: Theme JS-->

    <style>
        .auth-link {
            color: #fd810e;
            text-decoration: none;
            font-weight: 500;
        }
        .auth-link:hover {
            color: #ff6b35;
            text-decoration: underline;
        }
    </style>

    <script>
        $(window).on('load', function() {
            if (feather) {
                feather.replace({
                    width: 14,
                    height: 14
                });
            }
        });

        // Toggle password visibility
        $('.form-password-toggle .input-group-text').on('click', function(e) {
            e.preventDefault();
            var $this = $(this);
            var input = $this.closest('.input-group').find('input');
            
            if (input.attr('type') === 'password') {
                input.attr('type', 'text');
                $this.html('<i data-feather="eye-off"></i>');
            } else {
                input.attr('type', 'password');
                $this.html('<i data-feather="eye"></i>');
            }
            
            feather.replace({
                width: 14,
                height: 14
            });
        });

        // Toggle confirm password visibility
        $('.form-password-toggle-confirm .input-group-text').on('click', function(e) {
            e.preventDefault();
            var $this = $(this);
            var input = $this.closest('.input-group').find('input');
            
            if (input.attr('type') === 'password') {
                input.attr('type', 'text');
                $this.html('<i data-feather="eye-off"></i>');
            } else {
                input.attr('type', 'password');
                $this.html('<i data-feather="eye"></i>');
            }
            
            feather.replace({
                width: 14,
                height: 14
            });
        });
    </script>
</body>
</html>
