<!DOCTYPE html>
<html class="loading" lang="en" data-textdirection="ltr">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1.0,user-scalable=0,minimal-ui">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ __('Verify Email') }} - {{ config('app.name') }}</title>
    <link rel="icon" type="image/x-icon" href="{{ url('/') }}/app-assets/images/ico/favicon.ico" />
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600&display=swap" rel="stylesheet">
    
    <!-- BEGIN: Vendor CSS-->
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/vendors/css/vendors.min.css">
    <!-- END: Vendor CSS-->

    <!-- BEGIN: Theme CSS-->
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css/bootstrap.css">
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css/bootstrap-extended.css">
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css/colors.css">
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css/components.css">
    <!-- END: Theme CSS-->

    <!-- BEGIN: Page CSS-->
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css/core/menu/menu-types/vertical-menu.css">
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css/pages/authentication.css">
    <!-- END: Page CSS-->

    <style>
        .auth-wrapper.auth-basic {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .auth-card {
            background: #fff;
            border-radius: 1rem;
            box-shadow: 0 4px 25px 0 rgba(0, 0, 0, 0.1);
            padding: 2.5rem;
            max-width: 500px;
        }
        .brand-logo {
            text-align: center;
            margin-bottom: 2rem;
        }
        .brand-logo img {
            max-height: 60px;
            margin-bottom: 1rem;
        }
        .auth-title {
            font-size: 1.5rem;
            font-weight: 600;
            color: #5e5873;
            margin-bottom: 0.5rem;
        }
        .auth-subtitle {
            color: #6e6b7b;
            margin-bottom: 2rem;
        }
        .btn-verify {
            background: linear-gradient(135deg, #fd810e 0%, #ff6b35 100%);
            border: none;
            border-radius: 0.5rem;
            padding: 0.75rem 1.5rem;
            color: #fff;
            font-weight: 500;
            width: 100%;
            transition: all 0.3s ease;
        }
        .btn-verify:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px 0 rgba(253, 129, 14, 0.4);
            color: #fff;
        }
        .btn-logout {
            background: transparent;
            border: 1px solid #d8d6de;
            border-radius: 0.5rem;
            padding: 0.75rem 1.5rem;
            color: #6e6b7b;
            font-weight: 500;
            width: 100%;
            transition: all 0.3s ease;
        }
        .btn-logout:hover {
            border-color: #fd810e;
            color: #fd810e;
        }
        .alert-success {
            border-radius: 0.5rem;
            border-left: 3px solid #28c76f;
            background: #d4f4dd;
        }
        .info-box {
            background: #f8f8f8;
            border-radius: 0.5rem;
            padding: 1.5rem;
            text-align: center;
            margin-bottom: 2rem;
        }
        .info-box i {
            font-size: 3rem;
            color: #fd810e;
            margin-bottom: 1rem;
        }
        .info-box p {
            color: #6e6b7b;
            margin: 0;
        }
        .email-icon {
            width: 100px;
            height: 100px;
            background: linear-gradient(135deg, #fd810e 0%, #ff6b35 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1.5rem;
        }
        .email-icon svg {
            width: 50px;
            height: 50px;
            color: #fff;
        }
    </style>
</head>

<body class="vertical-layout vertical-menu-modern blank-page navbar-floating footer-static" data-open="click" data-menu="vertical-menu-modern" data-col="blank-page">
    <!-- BEGIN: Content-->
    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row"></div>
            <div class="content-body">
                <div class="auth-wrapper auth-basic px-2">
                    <div class="auth-inner my-2">
                        <div class="auth-card">
                            <!-- Logo -->
                            <div class="brand-logo">
                                @if(\App\Helpers\Helpers::setting('logoUrl'))
                                    <img src="{{ \App\Helpers\Helpers::setting('logoUrl') }}" alt="{{ config('app.name') }}">
                                @else
                                    <h2 class="brand-text text-primary mb-0">{{ config('app.name') }}</h2>
                                @endif
                            </div>

                            <!-- Email Icon -->
                            <div class="email-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="50" height="50" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path>
                                    <polyline points="22,6 12,13 2,6"></polyline>
                                </svg>
                            </div>

                            <!-- Title -->
                            <h2 class="auth-title text-center">{{ __('Verify Your Email') }} ✉️</h2>
                            <p class="auth-subtitle text-center">
                                {{ __('We have sent a verification link to your email address. Please check your inbox and click the link to verify your account.') }}
                            </p>

                            <!-- Success Message -->
                            @if (session('status') == 'verification-link-sent')
                                <div class="alert alert-success" role="alert">
                                    <div class="alert-body">
                                        <i data-feather="check-circle" class="me-50"></i>
                                        {{ __('A new verification link has been sent to your email address!') }}
                                    </div>
                                </div>
                            @endif

                            <!-- Info Box -->
                            <div class="info-box">
                                <i data-feather="info"></i>
                                <p>{{ __("Didn't receive the email? Check your spam folder or click the button below to resend.") }}</p>
                            </div>

                            <!-- Resend Verification Email -->
                            <form method="POST" action="{{ route('verification.send') }}" class="mb-2">
                                @csrf
                                <button type="submit" class="btn btn-verify">
                                    <i data-feather="mail" class="me-50"></i>
                                    {{ __('Resend Verification Email') }}
                                </button>
                            </form>

                            <!-- Logout -->
                            <form method="POST" action="{{ route('logout') }}">
                                @csrf
                                <button type="submit" class="btn btn-logout">
                                    <i data-feather="log-out" class="me-50"></i>
                                    {{ __('Log out') }}
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- END: Content-->

    <!-- BEGIN: Vendor JS-->
    <script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
    <!-- END: Vendor JS-->

    <!-- BEGIN: Theme JS-->
    <script src="{{ url('/') }}/app-assets/js/core/app-menu.js"></script>
    <script src="{{ url('/') }}/app-assets/js/core/app.js"></script>
    <!-- END: Theme JS-->

    <script>
        $(window).on('load', function() {
            if (feather) {
                feather.replace({
                    width: 14,
                    height: 14
                });
            }
        });
    </script>
</body>
</html>
