@include('layouts.header')
<link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/vendors/css/tables/datatable/dataTables.bootstrap5.min.css">

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="card-body">
            <button type="button" class="btn btn-primary float-end" data-bs-toggle="modal" data-bs-target="#addNew">{{ __('Add new autoreply') }}</button>
            <a class="btn btn-warning float-end" href="{{route('autoreply.samples', Auth::user()->id)}}">{{ __('Autoreply samples') }}</a>
        </div>
        <div class="content-header row">
            <h4>{{ __('Autoreply list') }}<span class="badge rounded-pill badge-light-secondary">{{DB::table('autoreplies')->where('user_id',Auth::user()->id)->count()}}</span></h4>
        </div>
        <div class="content-body">
            <!-- autoreply list start -->
            <section class="app-autoreply-list">
                <!-- list and filter start -->
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive table-responsive">
                            <table id="tbl-bootstr" class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th>{{ __('Device') }} {{ __('Sender') }}</th>
                                        <th>{{ __('Keyword') }}</th>
                                        <th>{{ __('Match %') }}</th>
                                        <th>{{ __('Response') }}</th>
                                        <th>{{ __('Media file') }}</th>
                                        <th>{{ __('Actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($autoreplies as $autoreply)
                                    <tr>
                                        <td><a href="javascript:;" data-bs-target="#edit-{{$autoreply->id}}" data-bs-toggle="modal">
                                        {{ empty($autoreply->device->name) ? '' : $autoreply->device->name }} ({{ strtoupper($autoreply->sender) }})</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-{{$autoreply->id}}" data-bs-toggle="modal">
                                        {{ $autoreply->keyword }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-{{$autoreply->id}}" data-bs-toggle="modal">
                                        {{ $autoreply->match_percent }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-{{$autoreply->id}}" data-bs-toggle="modal">
                                        {{ substr($autoreply->response, 0, 150) . '...' }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-{{$autoreply->id}}" data-bs-toggle="modal">
                                        @php($arrMediaurl=explode('/', $autoreply->mediaurl))
                                        {{ end($arrMediaurl) }}</a>
                                        </td>
                                        <td>
                                            <button class="btn btn-warning dropdown-toggle" type="button" id="actionButton-{{$autoreply->id}}" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i data-feather="command" class="me-0"></i>
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="actionButton-{{$autoreply->id}}">
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#edit-{{$autoreply->id}}"><i data-feather="edit" class="me-0"></i> {{__('Edit')}}</a>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#copy-{{$autoreply->id}}"><i data-feather="copy" class="me-0"></i> {{__('Copy')}}</a>
                                                @if(strpos($autoreply->data,'"replyButtons":[{"') > -1 || strpos($autoreply->data,'"templateButtons":[{"') > -1 || strpos($autoreply->data,'"listButtons":[{"'))
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#removeButtons-{{$autoreply->id}}"><i data-feather="trash" class="me-0"></i> {{__('Remove button')}}</a>
                                                @endif
                                                @if($autoreply->mediaurl)
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#removeMedia-{{$autoreply->id}}"><i data-feather="trash" class="me-0"></i> {{__('Remove media')}}</a>
                                                @endif
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroy-{{$autoreply->id}}"><i data-feather="trash" class="me-0"></i> {{__('Delete')}}</a>
                                            </div>
                                        </td>
                                    </tr>
                                    <!-- Delete Modal -->
                                    <div class="modal fade modal-danger text-start" id="destroy-{{$autoreply->id}}" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120">{{ __('Delete confirmation') }}</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    {{ __('Are you sure you want to delete?') }} <br><br>
                                                    <span class="text text-danger"> <b>{{ $autoreply->keyword }}</b> </span><br><br>
                                                    {{ __('This process is irreversible') }} <br>
                                                    {{ __('The record(s) will be deleted from the database permanently') }}
                                                </div>
                                                <div class="modal-footer">
                                                    <a class="btn btn-sm btn-danger" href="{{ route('autoreply.destroy', ['autoreply_id' => $autoreply->id]) }}">{{ __('Delete') }}</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Remove button Modal -->
                                    <div class="modal fade modal-danger text-start" id="removeButtons-{{$autoreply->id}}" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120">{{ __('Delete confirmation') }}</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    {{ __('Are you sure you want to delete?') }} <br><br>
                                                    <span class="text text-danger"> <b>{{ __('Button') }}</b> </span><br><br>
                                                    {{ __('This process is irreversible') }} <br>
                                                    {{ __('The record(s) will be deleted from the database permanently') }}
                                                </div>
                                                <div class="modal-footer">
                                                    <a class="btn btn-sm btn-danger" href="{{ route('autoreply.remove', ['autoreply_id' => $autoreply->id, 'action' => 'button']) }}">{{ __('Delete') }}</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Remove media Modal -->
                                    <div class="modal fade modal-danger text-start" id="removeMedia-{{$autoreply->id}}" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120">{{ __('Delete confirmation') }}</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    {{ __('Are you sure you want to delete?') }} <br><br>
                                                    <span class="text text-danger"> <b>{{ end($arrMediaurl) }}</b> </span><br><br>
                                                    {{ __('This process is irreversible') }} <br>
                                                    {{ __('The record(s) will be deleted from the database permanently') }}
                                                </div>
                                                <div class="modal-footer">
                                                    <a class="btn btn-sm btn-danger" href="{{ route('autoreply.remove', ['autoreply_id' => $autoreply->id, 'action' => 'media']) }}">{{ __('Delete') }}</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Edit Autoreply Modal -->
                                    <div class="modal fade" id="edit-{{$autoreply->id}}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-xl modal-dialog-centered modal-edit-autoreply">
                                            <div class="modal-content">
                                                <div class="modal-header bg-transparent">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body pb-5 px-sm-5 pt-50">
                                                    <div class="text-center mb-2">
                                                        <h1 class="mb-1">{{ __('Edit autoreply') }}</h1>
                                                    </div>
                                                    <form action="{{ route('autoreply.update') }}" method="POST" id="editAutoreplyForm" class="row gy-1 pt-75" enctype="multipart/form-data">
                                                        @csrf
                                                        <div class="row">
                                                            <div class="col-12">
                                                                <input type="hidden" name="autoreply_id" value="{{ $autoreply->id }}" />
                                                                <input type="hidden" name="prev_mediafile" value="{{ end($arrMediaurl) }}" />
                                                                <input type="hidden" name="prev_mediaurl" value="{{ $autoreply->mediaurl }}" />
                                                                <input type="hidden" name="prev_keyword" value="{{ $autoreply->keyword }}" />
                                                                <label class="form-label" for="sender">{{ __('Autoreply sender') }}</label>
                                                                <select class="form-control" name="sender">
                                                                    <option value="all" {{ ($autoreply->sender == "all" ? "selected" : "") }}>{{ __('ALL') }}</option>
                                                                    <option value="off" {{ ($autoreply->sender == "off" ? "selected" : "") }}>{{ __('OFF') }}</option>
                                                                    @foreach($devices as $device)
                                                                    <option value="{{ $device->sender }}" {{ ($autoreply->sender == $device->sender ? "selected" : "") }}>{{ $device->name . ' (' . $device->sender . ')' }}</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="keyword">{{ __('Autoreply keyword') }}</label> <label class="form-label text-warning"> ({{ __('Hello, Olá, Hallo') }}) </label>
                                                                <input type="text" name="keyword" class="form-control" value="{{ $autoreply->keyword }}" placeholder="{{ __('Autoreply keyword') }}" required />
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="match_percent">{{ __('Autoreply match percentage') }}</label>
                                                                <input type="text" name="match_percent" class="form-control" value="{{ $autoreply->match_percent }}" placeholder="1 - 100" required />
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="response">{{ __('Autoreply response') }}</label> <label class="form-label text-warning"> {name} {{ __('will display the receivers name') }} </label>
                                                                <textarea name="response" class="form-control" rows="6" placeholder="Response text" required>{{ $autoreply->response }}</textarea>
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label> {{ __('Emoji') }} ({{ __('Copy and Paste') }})</label>
                                                                <textarea name="emoji" class="form-control" rows="7" readonly>{{ file_get_contents(public_path('app-assets/data/emoji.txt')) }}</textarea><br>
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="mediafile">{{ __('Autoreply mediafile') }}</label> <label class="form-label text-warning"> ({{ __('Optional') }}) </label> <label class="form-label text-warning"> JPEG/PNG/GIF/PDF/DOCX/PPTX/XLSX/CSV/MP3 </label>
                                                                <input type="file" name="mediafile" class="form-control" />{{ end($arrMediaurl) }}<br>
                                                            </div><hr>
                                                            <div class="col-12 text-center mt-2 pt-50">
                                                                <button type="submit" class="btn btn-primary me-1">{{ __('Submit') }}</button>
                                                                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">{{ __('Cancel') }}</button>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--/ Edit Autoreply Modal -->
                                    <!--/ Copy Autoreply Modal -->
                                    <div class="modal fade" id="copy-{{$autoreply->id}}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-lg modal-dialog-centered modal-edit-user">
                                            <div class="modal-content">
                                                <div class="modal-header bg-transparent">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body pb-5 px-sm-5 pt-50">
                                                    <div class="text-center mb-2">
                                                        <h1 class="mb-1">{{ __('Copy autoreply') }}</h1>
                                                    </div>
                                                    <form action="{{ route('autoreply.copy') }}" method="GET" id="copyAutoreplyForm" class="row gy-1 pt-75" enctype="multipart/form-data">
                                                        @csrf
                                                        <div class="row">
                                                            <div class="col-12 col-md-6">
                                                                <input type="hidden" name="autoreply_id" value="{{ $autoreply->id }}" />
                                                                <label class="form-label" for="autoreply_keyword">{{ __('Autoreply keyword') }}</label>
                                                                <input type="text" name="autoreply_keyword" class="form-control" value="{{ $autoreply->keyword }}" required readonly />
                                                            </div>
                                                            @if(Auth::user()->role === 'admin')
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="to_user">{{ __('To User') }}</label>
                                                                <select class="select2 form-select" id="to_userid-{{$autoreply->id}}" onchange="changeDevice(this, {{Auth::user()->id}}, {{$autoreply->id}})" name="to_userid">
                                                                    <option value="">{{ __('Select User') }}</option>
                                                                    <optgroup label="Admins">
                                                                    @foreach($adminUsers as $adminUser)
                                                                    @if($adminUser->id == 2) @continue @endif
                                                                        <option value="{{$adminUser->id}}" {{ $adminUser->id === $autoreply->user->id ? 'selected' : '' }}>{{$adminUser->name}}</option>
                                                                    @endforeach
                                                                    </optgroup>
                                                                    <optgroup label="Users">
                                                                    @foreach($userUsers as $userUser)
                                                                        <option value="{{$userUser->id}}" {{ $userUser->id === $autoreply->user->id ? 'selected' : '' }}>{{$userUser->name}}</option>
                                                                    @endforeach
                                                                    </optgroup>
                                                                </select>
                                                            </div>
                                                            @else
                                                            <input type="hidden" name="to_userid" value="{{ $autoreply->user_id }}" />
                                                            @endif
                                                            <div class="col-12 col-md-6" id="selectDevice-{{$autoreply->id}}">
                                                                <label class="form-label" for="label_to_sender">{{ __('To Device') }}</label>
                                                                <select class="select2 form-select" id="to_sender-{{$autoreply->id}}" name="to_sender">
                                                                    <option value="">{{ __('Select Device') }}</option>
                                                                    @foreach($devices as $device)
                                                                        <option value="{{$device->sender}}">{{$device->name}} ({{$device->sender}})</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                            <div class="col-12 text-center mt-2 pt-50">
                                                                <button type="submit" class="btn btn-primary me-1">{{ __('Submit') }}</button>
                                                                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">{{ __('Cancel') }}</button>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--/ Copy Autoreply Modal -->
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- Modal to add new autoreply starts-->
                        <div class="modal modal-slide-in new-autoreply-modal fade" id="addNew">
                            <div class="modal-dialog">
                                <form action="{{ route('autoreply.store') }}" method="POST" class="modal-content pt-0" enctype="multipart/form-data">
                                @csrf
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
                                    <div class="modal-header mb-1">
                                        <h5 class="modal-title" id="exampleModalLabel">{{ __('Add new autoreply') }}</h5>
                                    </div>
                                    <div class="modal-body flex-grow-1">
                                        <div class="mb-1">
                                            <label class="form-label" for="sender">{{ __('Autoreply sender') }}</label>
                                            <select class="form-control" name="sender">
                                                <option value="all">{{ __('ALL') }}</option>
                                                <option value="off">{{ __('OFF') }}</option>
                                                @foreach($devices as $device)
                                                <option value="{{ $device->sender }}">{{ $device->name . ' (' . $device->sender . ')' }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="keyword">{{ __('Autoreply keyword') }}</label> <label class="form-label text-warning"> ({{ __('Hello, Olá, Hallo') }}) </label>
                                            <input type="text" name="keyword" class="form-control" placeholder="{{ __('Autoreply keyword') }}" required />
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="match_percent">{{ __('Autoreply match percentage') }}</label>
                                            <input type="number" name="match_percent" class="form-control dt-dname" placeholder="1 - 100" value="100" required />
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="response">{{ __('Autoreply response') }}</label>
                                            <textarea name="response" class="form-control" rows="6" placeholder="{name} {{ __('will display the receivers name') }}" required></textarea>
                                        </div>
                                        <div class="mb-1">
                                            <label> {{ __('Emoji') }} ({{ __('Copy and Paste') }})</label>
                                            <textarea name="emoji" class="form-control" rows="7" readonly>{{ file_get_contents(public_path('app-assets/data/emoji.txt')) }}</textarea><br>
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="mediafile">{{ __('Autoreply mediafile') }}</label> <label class="form-label text-warning"> ({{ __('Optional') }}) </label> <label class="form-label text-warning"> JPEG/PNG/GIF/PDF/DOCX/PPTX/XLSX/CSV/MP3 </label>
                                            <input type="file" name="mediafile" class="form-control" placeholder="{{ __('Autoreply mediafile') }}" /><br>
                                        </div>
                                        <button type="submit" class="btn btn-primary me-1 data-submit">{{ __('Submit') }}</button>
                                        <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- Modal to add new autoreply Ends-->
                    </div>
                </div>
                <!-- list and filter end -->
            </section>
            <!-- autoreply list ends -->
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- BEGIN: Vendor JS-->
<script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
<script src="{{ url('/') }}/app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js"></script>
<script src="{{ url('/') }}/app-assets/vendors/js/tables/datatable/dataTables.bootstrap5.min.js"></script>
<!-- BEGIN Vendor JS-->
<script>
    $(document).ready(function () {
        $('#tbl-bootstr').DataTable();
    });        
</script>
<script>
    function changeDevice(name_drop, authId, autoreplyId) {
        var selectId = name_drop.value;
        if (authId == selectId) {
            document.getElementById("selectDevice-" + autoreplyId).style.display = 'block';
        } else {
            document.getElementById("selectDevice-" + autoreplyId).style.display = 'none';
            document.getElementById("to_sender-" + autoreplyId).value = '';
        }
    }
</script>

@include('layouts.footer')
