@include('layouts.header')
<link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/vendors/css/tables/datatable/dataTables.bootstrap5.min.css">

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="card-body">
            <button type="button" class="btn btn-sm btn-danger float-end dropdown-toggle" id="trashButton" data-bs-toggle="dropdown" aria-expanded="false">
                <i data-feather="trash" class="me-0"></i> {{ strtoupper(__('Delete')) }}
            </button>
            <div class="dropdown-menu" aria-labelledby="trashButton">
                @if(is_array($subjects) || is_object($subjects))
                    @foreach($subjects as $key => $value)
                    <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroySubject-{{$key}}"><i data-feather="trash" class="me-0"></i> {{__('ALL')}} ({{$key}})</a>
                    @endforeach
                @endif
            </div>
            @if(is_array($subjects) || is_object($subjects))
                @foreach($subjects as $key => $value)
                <!-- Modal destroySubject-->
                <div class="modal fade modal-danger text-start" id="destroySubject-{{$key}}" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="myModalLabel120">{{ __('Delete confirmation') }}</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                {{ __('Are you sure you want to delete?') }} <br><br>
                                <span class="text text-danger"> <b>{{__('ALL')}} ({{$key}})</b> </span><br><br>
                                {{ __('This process is irreversible') }} <br>
                                {{ __('The record(s) will be deleted from the database permanently') }}
                            </div>
                            <div class="modal-footer">
                            <a class="btn btn-sm btn-danger" href="{{ route('capture.destroySubject', ['captureSubject' => $key]) }}">{{ __('Delete') }}</a>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            @endif

            <button type="button" class="btn btn-sm btn-success float-end dropdown-toggle" id="exportButton" data-bs-toggle="dropdown" aria-expanded="false">
                <i data-feather="filter" class="me-0"></i> {{ strtoupper(__('Export')) }}
            </button>
            <div class="dropdown-menu" aria-labelledby="exportButton">
                @if(is_array($subjects) || is_object($subjects))
                    @foreach($subjects as $key => $value)
                    <a class="dropdown-item" href="{{ route('capture.exportSubject', ['captureSubject' => $key]) }}"><i data-feather="external-link" class="me-0"></i> {{__('Export')}} {{$key}}</a>
                    @endforeach
                @endif
            </div>
            
            <button type="button" class="btn btn-sm btn-primary float-end" data-bs-toggle="modal" data-bs-target="#showCaptureSubject">{{ strtoupper(__('Show subjects')) }}</button>
        </div>
        <div class="content-header row">
            <h4>{{ __('Capture list') }}<span class="badge rounded-pill badge-light-secondary">{{DB::table('capture_items')->where('user_id',Auth::user()->id)->count()}}</span></h4>
        </div>
        <div class="content-body">
            <!-- job list start -->
            <section class="app-job-list">
                <!-- list and filter start -->
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive table-responsive">
                            <table id="tbl-bootstr" class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th> {{ __('Name') }} </th>
                                        <th> {{ __('Phone') }} </th>
                                        <th> {{ __('Subject') }} </th>
                                        <th> {{ __('Data') }} </th>
                                        <th> {{ __('Date') }} </th>
                                        <th> {{ __('Actions') }} </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($captureItems as $captureItem)
                                    @if(empty($captureItem)) @continue @endif
                                    <tr>
                                        <!-- <td hidden>{{ $captureItem->data }}</td> -->
                                        <td><a href="javascript:;" data-bs-target="#editCaptureItem-{{$captureItem->id}}" data-bs-toggle="modal">
                                        {{ $captureItem->capture->name ?? '' }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#editCaptureItem-{{$captureItem->id}}" data-bs-toggle="modal">
                                        {{ $captureItem->capture->phone ?? '' }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#editCaptureItem-{{$captureItem->id}}" data-bs-toggle="modal">
                                        {{ $captureItem->subject }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#editCaptureItem-{{$captureItem->id}}" data-bs-toggle="modal">
                                        {{ $captureItem->data }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#editCaptureItem-{{$captureItem->id}}" data-bs-toggle="modal">
                                        {{ $captureItem->created_at }}</a>
                                        </td>
                                        <td>
                                            <button class="btn btn-warning dropdown-toggle" type="button" id="actionButton" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i data-feather="command" class="me-0"></i>
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="actionButton">
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#editCaptureItem-{{$captureItem->id}}"><i data-feather="eye" class="me-0"></i> {{__('View')}}</a>
                                                <a class="dropdown-item" href="{{ route('capture.exportItem', ['captureItem_id' => $captureItem->id]) }}"><i data-feather="external-link" class="me-0"></i> {{ __('Export') }}</a>
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroy-{{$captureItem->id}}"><i data-feather="trash" class="me-0"></i> {{__('Delete')}}</a>
                                            </div>
                                        </td>
                                    </tr>
                                    <!-- Delete Modal -->
                                    <div class="modal fade modal-danger text-start" id="destroy-{{$captureItem->id}}" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120">{{ __('Delete confirmation') }}</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    {{ __('Are you sure you want to delete?') }} <br><br>
                                                    <span class="text text-danger"> <b>{{ $captureItem->id }}</b> </span><br><br>
                                                    {{ __('This process is irreversible') }} <br>
                                                    {{ __('The record(s) will be deleted from the database permanently') }}
                                                </div>
                                                <div class="modal-footer">
                                                <a class="btn btn-sm btn-danger" href="{{ route('capture.destroy', ['captureItem_id' => $captureItem->id]) }}">{{ __('Delete') }}</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Edit CaptureItem Modal -->
                                    <div class="modal fade" id="editCaptureItem-{{$captureItem->id}}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-xl modal-dialog-centered modal-edit-captureItem">
                                            <div class="modal-content">
                                                <div class="modal-header bg-transparent">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body pb-5 px-sm-5 pt-50">
                                                    <div class="text-center mb-2">
                                                        <h1 class="mb-1">{{ __('Edit capture') }}</h1>
                                                    </div>
                                                    <form action="{{ route('capture.update') }}" method="POST" id="editCaptureItemForm" class="row gy-1 pt-75" enctype="multipart/form-data">
                                                        @csrf
                                                        <!-- <div class="row"> -->
                                                        <!-- <div class="col-12 col-md-6"> -->
                                                        <div class="col-12">
                                                            <input type="hidden"  name="captureItem_id" value="{{ $captureItem->id }}" />
                                                            <label class="form-label" for="subject">{{ __('Capture subject') }}</label>
                                                            <input type="text" name="subject" class="form-control" value="{{ $captureItem->subject }}" placeholder="{{ __('Capture subject') }}" readonly />
                                                        </div>
                                                        <!-- <div class="col-12 col-md-6"> -->
                                                        <div class="col-12">
                                                            <label class="form-label" for="data">{{ __('Capture data') }}</label>
                                                            <textarea name="data" rows="15" class="form-control" placeholder="{{ __('Capture data') }}">{{ json_encode(json_decode($captureItem->data), JSON_PRETTY_PRINT) }}</textarea>
                                                        </div>
                                                        <div class="col-12 text-center mt-2 pt-50">
                                                            <button type="submit" class="btn btn-primary me-1">{{ __('Save') }}</button>
                                                            <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">{{ __('Cancel') }}</button>
                                                        </div>
                                                        <!-- </div> -->
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--/ Edit CaptureItem Modal -->
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- Show CaptureSubjects Modal -->
                        <div class="modal fade" id="showCaptureSubject" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog modal-xl modal-dialog-centered modal-showCaptureSubject">
                                <div class="modal-content">
                                    <div class="modal-header bg-transparent">
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body pb-5 px-sm-5 pt-50">
                                        <div class="text-center mb-2">
                                            <h1 class="mb-1">{{ __('Show subjects') }}</h1>
                                        </div>
                                        <div class="card-body">
                                            <form action="{{ route('capture.saveSubjects') }}" method="GET" id="saveSubjects" enctype="multipart/form-data" class="invoice-repeater">
                                                <input type="hidden" name="user_id" value="{{Auth::user()->id}}">
                                                <div data-repeater-list="subjects">
                                                    @if(is_array($subjects) || is_object($subjects))
                                                        @foreach($subjects as $key => $value)
                                                        <div data-repeater-item>
                                                            <div class="row d-flex align-items-end">
                                                                <div class="col-md-2 col-12">
                                                                    <div class="mb-1">
                                                                        <label class="form-label" for="subject">{{ __('Subject') }}</label>
                                                                        <input type="text" id="subject" name="subject" value="{{$key}}" class="form-control" aria-describedby="subject" />
                                                                    </div>
                                                                </div>

                                                                <div class="col-md-9 col-12">
                                                                    <div class="mb-1">
                                                                        <label class="form-label" for="questions">{{ __('Questions') }}</label>
                                                                        <textarea id="questions" name="questions" rows="6" class="form-control" aria-describedby="questions">{{json_encode($value, JSON_PRETTY_PRINT)}}</textarea>
                                                                    </div>
                                                                </div>

                                                                <div class="col-md-1 col-12 mb-50">
                                                                    <div class="mb-1">
                                                                        <button class="btn btn-outline-danger text-nowrap px-1" data-repeater-delete type="button">
                                                                            <i data-feather="trash" class="me-0"></i>
                                                                        </button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <hr />
                                                        </div>
                                                        @endforeach
                                                    @endif
                                                </div>
                                                <div class="row">
                                                    <div class="col-12">
                                                        <button class="btn btn-icon btn-primary" type="button" data-repeater-create>
                                                            <i data-feather="plus" class="me-25"></i>
                                                            <span>{{ __('Add new') }}</span>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="col-12 text-center mt-2 pt-50">
                                                    <button type="submit" class="btn btn-primary me-1">{{ __('Save') }}</button>
                                                    <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">{{ __('Cancel') }}</button>
                                                </div>
                                                <a class="btn btn-warning me-1 data-submit" href="{{ route('capture.resetSubjects', ['user_id' => $user->id]) }}">{{ __('Reset') }}</a>
                                                <label class="form-label text-warning">{{ __('_MsgSubjectsReset') }}</label>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--/ Edit Phonebook Modal -->
                    </div>
                    <!-- list and filter end -->
                </div>
            </section>
            <!-- jobs list ends -->
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- BEGIN: Vendor JS-->
<script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
<script src="{{ url('/') }}/app-assets/vendors/js/forms/repeater/jquery.repeater.min.js"></script>
<script src="{{ url('/') }}/app-assets/js/scripts/forms/form-repeater.js"></script>
<script src="{{ url('/') }}/app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js"></script>
<script src="{{ url('/') }}/app-assets/vendors/js/tables/datatable/dataTables.bootstrap5.min.js"></script>
<!-- BEGIN Vendor JS-->
<script>
    $(document).ready(function () {
        $('#tbl-bootstr').DataTable();
    });        
</script>

@include('layouts.footer')
